/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.compute;

import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.Tenant;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import com.woorea.openstack.nova.Nova;
import com.woorea.openstack.nova.model.Flavor;
import com.woorea.openstack.nova.model.Flavors;

public class NovaListFlavors {
    public static void main(String[] args) {
        Keystone keystone = new Keystone("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v3");
        Access access = (Access)keystone.tokens().authenticate((Authentication)new UsernamePassword("", "")).execute();
        keystone.token(access.getToken().getId());
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            access = (Access)keystone.tokens().authenticate((Authentication)new TokenAuthentication(access.getToken().getId())).withTenantId(((Tenant)tenants.getList().get(0)).getId()).execute();
            Nova novaClient = new Nova("http://compute/v2".concat("/").concat(((Tenant)tenants.getList().get(0)).getId()));
            novaClient.token(access.getToken().getId());
            Flavors flavors = (Flavors)novaClient.flavors().list(true).execute();
            for (Flavor flavor : flavors) {
                System.out.println(flavor);
            }
        } else {
            System.out.println("No tenants found!");
        }
    }
}

