/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.glance;

import com.woorea.openstack.glance.Glance;
import com.woorea.openstack.glance.model.Image;
import com.woorea.openstack.glance.model.ImageDownload;
import com.woorea.openstack.glance.model.ImageUpload;
import com.woorea.openstack.glance.model.Images;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.utils.KeystoneTokenProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GlanceListImages {
    protected static String IMAGE_CONTENT = "Hello World!";

    public static void main(String[] args) {
        KeystoneTokenProvider keystone = new KeystoneTokenProvider("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v3", "", "");
        Access access = keystone.getAccessByTenant("admin");
        Access.Service glanceService = null;
        for (Access.Service service : access.getServiceCatalog()) {
            if (!service.getType().equals("image")) continue;
            glanceService = service;
            break;
        }
        if (glanceService == null) {
            throw new RuntimeException("Glance service not found");
        }
        for (Access.Service.Endpoint endpoint : glanceService.getEndpoints()) {
            Glance glance = new Glance(endpoint.getPublicURL() + "/v1");
            glance.setTokenProvider(keystone.getProviderByTenant("admin"));
            Image newImage = new Image();
            newImage.setDiskFormat("raw");
            newImage.setContainerFormat("bare");
            newImage.setName("os-java-glance-test");
            newImage = (Image)glance.images().create(newImage).execute();
            ImageUpload uploadImage = new ImageUpload(newImage);
            uploadImage.setInputStream((InputStream)new ByteArrayInputStream(IMAGE_CONTENT.getBytes()));
            glance.images().upload(newImage.getId(), uploadImage).execute();
            try {
                byte[] imgContent = new byte[IMAGE_CONTENT.length()];
                ImageDownload downloadImage = glance.images().download(newImage.getId()).execute();
                downloadImage.getInputStream().read(imgContent, 0, imgContent.length);
                System.out.println(new String(imgContent));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Images images = (Images)glance.images().list(false).execute();
            for (Image image : images) {
                System.out.println(glance.images().show(image.getId()).execute());
            }
            glance.images().delete(newImage.getId()).execute();
        }
    }
}

