/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.examples.network;

import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.Tenants;
import com.woorea.openstack.keystone.model.authentication.TokenAuthentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import com.woorea.openstack.keystone.utils.KeystoneUtils;
import com.woorea.openstack.quantum.Quantum;
import com.woorea.openstack.quantum.model.Network;
import com.woorea.openstack.quantum.model.NetworkForCreate;
import com.woorea.openstack.quantum.model.Networks;
import com.woorea.openstack.quantum.model.Router;
import com.woorea.openstack.quantum.model.RouterForAddInterface;
import com.woorea.openstack.quantum.model.RouterForCreate;
import com.woorea.openstack.quantum.model.Subnet;
import com.woorea.openstack.quantum.model.SubnetForCreate;
import java.util.List;

public class QuantumNetworkCreate {
    public static void main(String[] args) {
        Keystone keystone = new Keystone("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v3");
        Access access = (Access)keystone.tokens().authenticate((Authentication)new UsernamePassword("", "")).execute();
        keystone.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
        keystone.token(access.getToken().getId());
        Tenants tenants = (Tenants)keystone.tenants().list().execute();
        if (tenants.getList().size() > 0) {
            Network network = new Network();
            access = (Access)keystone.tokens().authenticate((Authentication)new TokenAuthentication(access.getToken().getId())).withTenantId("tenantId").execute();
            Quantum quantum = new Quantum(KeystoneUtils.findEndpointURL((List)access.getServiceCatalog(), (String)"network", null, (String)"public"));
            quantum.setTokenProvider((OpenStackTokenProvider)new OpenStackSimpleTokenProvider(access.getToken().getId()));
            NetworkForCreate netcreate = new NetworkForCreate();
            netcreate.setTenantId("tenantId");
            netcreate.setName("net2");
            netcreate.setAdminStateUp(Boolean.valueOf(true));
            network = (Network)quantum.networks().create((Network)netcreate).execute();
            try {
                Subnet sub = new Subnet();
                SubnetForCreate subnet = new SubnetForCreate();
                subnet.setCidr("");
                subnet.setName("");
                subnet.setNetworkId(network.getId());
                subnet.setIpVersion(4);
                sub = (Subnet)quantum.subnets().create((Subnet)subnet).execute();
                RouterForCreate routerForCreate = new RouterForCreate();
                routerForCreate.setName("routerName");
                routerForCreate.setTenantId("tenantId");
                Router router = (Router)quantum.routers().create(routerForCreate).execute();
                RouterForAddInterface routerForAdd = new RouterForAddInterface();
                routerForAdd.setSubnetId(sub.getId());
                routerForAdd.setRouterId(router.getId());
                quantum.routers().addInterface(routerForAdd).execute();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            Networks networks = (Networks)quantum.networks().list().execute();
            for (Network network1 : networks) {
                System.out.println(network1);
            }
        } else {
            System.out.println("No tenants found!");
        }
    }
}

