/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.java;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.gremlin.pipes.filter.IntervalFilterPipe;
import com.tinkerpop.gremlin.pipes.filter.PropertyFilterPipe;
import com.tinkerpop.gremlin.pipes.transform.QueryPipe;
import com.tinkerpop.gremlin.pipes.transform.VerticesEdgesPipe;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.filter.RangeFilterPipe;
import com.tinkerpop.pipes.transform.IdentityPipe;
import com.tinkerpop.pipes.util.FluentUtility;
import com.tinkerpop.pipes.util.Pipeline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GremlinFluentUtility
extends FluentUtility {
    public static List<Pipe> removeEdgeQueryOptimizationPipes(GremlinPipeline pipeline) {
        int numberedStep = -1;
        int pipelineSize = pipeline.size();
        boolean filtersSeen = false;
        for (int i = pipelineSize - 1; i >= 0; --i) {
            Pipe pipe = pipeline.get(i);
            if (pipe instanceof VerticesEdgesPipe) {
                numberedStep = pipelineSize - i;
                break;
            }
            if (pipe instanceof PropertyFilterPipe || pipe instanceof IntervalFilterPipe || pipe instanceof RangeFilterPipe) {
                if (pipe instanceof RangeFilterPipe && ((RangeFilterPipe)pipe).getLowRange() != 0L) break;
                filtersSeen = true;
                continue;
            }
            if (!(pipe instanceof IdentityPipe)) break;
        }
        if (numberedStep != -1 && filtersSeen) {
            return FluentUtility.removePreviousPipes((Pipeline)pipeline, (int)numberedStep);
        }
        return Collections.emptyList();
    }

    public static GremlinPipeline optimizePipelineForVertexQueries(GremlinPipeline pipeline) {
        List<Pipe> removedPipes = GremlinFluentUtility.removeEdgeQueryOptimizationPipes(pipeline);
        if (removedPipes.size() > 0) {
            ArrayList<QueryPipe.HasContainer> hasContainers = new ArrayList<QueryPipe.HasContainer>();
            ArrayList<QueryPipe.IntervalContainer> intervalContainers = new ArrayList<QueryPipe.IntervalContainer>();
            long limit = -1L;
            String[] labels = new String[]{};
            Direction direction = Direction.BOTH;
            for (Pipe pipe : removedPipes) {
                AbstractPipe temp;
                if (pipe instanceof PropertyFilterPipe) {
                    temp = (PropertyFilterPipe)pipe;
                    hasContainers.add(new QueryPipe.HasContainer(temp.getKey(), temp.getValue(), GremlinFluentUtility.convertFromFilter(temp.getFilter())));
                    continue;
                }
                if (pipe instanceof IntervalFilterPipe) {
                    temp = (IntervalFilterPipe)pipe;
                    intervalContainers.add(new QueryPipe.IntervalContainer(temp.getKey(), temp.getStartValue(), temp.getEndValue()));
                    continue;
                }
                if (pipe instanceof VerticesEdgesPipe) {
                    labels = ((VerticesEdgesPipe)pipe).getLabels();
                    direction = ((VerticesEdgesPipe)pipe).getDirection();
                    continue;
                }
                if (!(pipe instanceof RangeFilterPipe)) continue;
                limit = ((RangeFilterPipe)pipe).getHighRange() + 1L;
            }
            pipeline.addPipe((Pipe)new QueryPipe<Edge>(Edge.class, direction, hasContainers, intervalContainers, limit, labels));
            for (int i = 0; i < removedPipes.size() - 1; ++i) {
                pipeline.addPipe((Pipe)new IdentityPipe());
            }
        }
        return pipeline;
    }

    private static Query.Compare convertFromFilter(FilterPipe.Filter filter) {
        if (filter.equals((Object)FilterPipe.Filter.EQUAL)) {
            return Query.Compare.EQUAL;
        }
        if (filter.equals((Object)FilterPipe.Filter.GREATER_THAN)) {
            return Query.Compare.GREATER_THAN;
        }
        if (filter.equals((Object)FilterPipe.Filter.GREATER_THAN_EQUAL)) {
            return Query.Compare.GREATER_THAN_EQUAL;
        }
        if (filter.equals((Object)FilterPipe.Filter.LESS_THAN)) {
            return Query.Compare.LESS_THAN;
        }
        if (filter.equals((Object)FilterPipe.Filter.LESS_THAN_EQUAL)) {
            return Query.Compare.LESS_THAN_EQUAL;
        }
        if (filter.equals((Object)FilterPipe.Filter.NOT_EQUAL)) {
            return Query.Compare.NOT_EQUAL;
        }
        throw new IllegalStateException("The provided filter is not a legal filter: " + filter);
    }
}

