/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.pipes.transform;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class QueryPipe<E extends Element>
extends AbstractPipe<Vertex, E> {
    private Direction direction = Direction.BOTH;
    private String[] labels;
    private List<HasContainer> hasContainers;
    private List<IntervalContainer> intervalContainers;
    private final Class<E> elementClass;
    private final long limit;
    private Iterator<E> currentIterator = PipeHelper.emptyIterator();

    public QueryPipe(Class<E> resultingElementClass, Direction direction, List<HasContainer> hasContainers, List<IntervalContainer> intervalContainers, long limit, String ... labels) {
        this.elementClass = resultingElementClass;
        this.direction = direction;
        this.hasContainers = hasContainers;
        this.intervalContainers = intervalContainers;
        this.labels = labels;
        this.limit = limit;
        if (!resultingElementClass.equals(Vertex.class) && !resultingElementClass.equals(Edge.class)) {
            throw new IllegalArgumentException("The provided element class must be either Vertex or Edge");
        }
    }

    public void reset() {
        super.reset();
        this.currentIterator = PipeHelper.emptyIterator();
    }

    public String toString() {
        String extra = "has:" + (this.hasContainers.size() > 0) + ",interval:" + (this.intervalContainers.size() > 0) + ",limit:" + this.limit;
        return PipeHelper.makePipeString((Pipe)this, (Object[])new Object[]{this.direction.name().toLowerCase(), Arrays.asList(this.labels), extra, this.elementClass.getSimpleName().toLowerCase()});
    }

    public E processNextStart() {
        while (!this.currentIterator.hasNext()) {
            Vertex vertex = (Vertex)this.starts.next();
            Query query = vertex.query();
            query = query.direction(this.direction);
            if (this.labels.length > 0) {
                query = query.labels(this.labels);
            }
            if (this.hasContainers.size() > 0) {
                for (HasContainer hasContainer : this.hasContainers) {
                    if (hasContainer.compare.equals((Object)Query.Compare.EQUAL)) {
                        query = query.has(hasContainer.key, hasContainer.value);
                        continue;
                    }
                    query = query.has(hasContainer.key, (Comparable)hasContainer.value, hasContainer.compare);
                }
            }
            if (this.intervalContainers.size() > 0) {
                for (IntervalContainer intervalContainer : this.intervalContainers) {
                    query = query.interval(intervalContainer.key, (Comparable)intervalContainer.startValue, (Comparable)intervalContainer.endValue);
                }
            }
            if (this.limit > -1L) {
                query = query.limit(this.limit);
            }
            if (this.elementClass.equals(Vertex.class)) {
                this.currentIterator = query.vertices().iterator();
                continue;
            }
            this.currentIterator = query.edges().iterator();
        }
        return (E)((Element)this.currentIterator.next());
    }

    public static class IntervalContainer {
        public String key;
        public Object startValue;
        public Object endValue;

        public IntervalContainer(String key, Object startValue, Object endValue) {
            this.key = key;
            this.startValue = startValue;
            this.endValue = endValue;
        }
    }

    public static class HasContainer {
        public String key;
        public Object value;
        public Query.Compare compare;

        public HasContainer(String key, Object value, Query.Compare compare) {
            this.key = key;
            this.value = value;
            this.compare = compare;
        }
    }
}

