/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.communication;

import com.vaadin.server.CustomizedSystemMessages;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.SystemMessagesProvider;
import com.xdev.communication.XdevServlet;
import com.xdev.communication.XdevServletExtension;
import com.xdev.mobile.config.MobileConfiguration;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MobileServletExtension
implements XdevServletExtension {
    private static Logger LOG = Logger.getLogger(MobileServletExtension.class.getName());

    public void servletInitialized(XdevServlet servlet) throws ServletException {
        servlet.getService().setSystemMessagesProvider((SystemMessagesProvider & Serializable)systemMessagesInfo -> {
            CustomizedSystemMessages messages = new CustomizedSystemMessages();
            messages.setSessionExpiredNotificationEnabled(false);
            messages.setCommunicationErrorNotificationEnabled(false);
            return messages;
        });
        MobileConfiguration mobileConfiguration = this.readMobileConfiguration(servlet);
        servlet.getService().addSessionInitListener((SessionInitListener & Serializable)event -> event.getSession().setAttribute(MobileConfiguration.class, (Object)mobileConfiguration));
    }

    protected MobileConfiguration readMobileConfiguration(XdevServlet servlet) {
        MobileConfiguration.Default config = new MobileConfiguration.Default();
        try {
            URL url = this.findMobileXML(servlet);
            if (url == null) {
                LOG.log(Level.WARNING, "No mobile.xml found");
            } else {
                Document document = new SAXReader().read(url);
                Optional.ofNullable(document.getRootElement()).map(e -> e.element("services")).ifPresent(servicesElement -> {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    config.setMobileServices(servicesElement.elements("service").stream().filter(Element.class::isInstance).map(Element.class::cast).map(serviceElement -> this.createServiceConfiguration(classLoader, (Element)serviceElement)).filter(Objects::nonNull).collect(Collectors.toList()));
                });
            }
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, e2.getMessage(), e2);
        }
        return config;
    }

    protected MobileServiceConfiguration createServiceConfiguration(ClassLoader classLoader, Element serviceElement) {
        String className = serviceElement.attributeValue("class");
        try {
            Class<?> serviceClass = classLoader.loadClass(className);
            if (!AbstractMobileService.class.isAssignableFrom(serviceClass)) {
                throw new IllegalArgumentException(String.valueOf(className) + " is not a " + AbstractMobileService.class.getSimpleName());
            }
            Map<String, String> params = serviceElement.elements("param").stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toMap(e -> e.attributeValue("name"), e -> e.attributeValue("value")));
            MobileServiceConfiguration.Default configuration = new MobileServiceConfiguration.Default();
            configuration.setServiceClass(serviceClass);
            configuration.setParameters(params);
            return configuration;
        }
        catch (Exception e2) {
            LOG.log(Level.SEVERE, e2.getMessage(), e2);
            return null;
        }
    }

    protected URL findMobileXML(XdevServlet servlet) throws MalformedURLException {
        ClassLoader classLoader = servlet.getService().getClassLoader();
        URL resourceUrl = classLoader.getResource("META-INF/mobile.xml");
        if (resourceUrl == null && (resourceUrl = servlet.getServletContext().getResource("/mobile.xml")) == null) {
            resourceUrl = classLoader.getResource("mobile.xml");
        }
        return resourceUrl;
    }
}

