/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractJavaScriptExtension;
import com.vaadin.ui.UI;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.MobileServiceError;
import elemental.json.JsonArray;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractMobileService
extends AbstractJavaScriptExtension {
    private final MobileServiceConfiguration configuration;

    public static <T extends AbstractMobileService> T getMobileService(Class<T> clazz) {
        UI ui = UI.getCurrent();
        return (T)((Object)((AbstractMobileService)ui.getExtensions().stream().filter(e -> e.getClass().equals(clazz)).map(clazz::cast).findFirst().orElse(null)));
    }

    protected AbstractMobileService(AbstractClientConnector target, MobileServiceConfiguration configuration) {
        super(target);
        this.configuration = configuration;
    }

    public MobileServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    protected String generateCallerID() {
        return Long.toString(System.nanoTime(), 36);
    }

    protected String toLiteral(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 2);
        sb.append('\"');
        int i = 0;
        int len = str.length();
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    protected void callError(JsonArray arguments, Map<String, ? extends ServiceCall<?, MobileServiceError>> callMap, boolean remove) {
        ServiceCall<?, MobileServiceError> call;
        String id = arguments.getString(0);
        ServiceCall<?, MobileServiceError> serviceCall = call = remove ? callMap.remove(id) : callMap.get(id);
        if (call != null) {
            call.error(new MobileServiceError(this, arguments.get(1).asString()));
        }
    }

    protected static interface ServiceCall<R, E extends MobileServiceError> {
        public static <R, E extends MobileServiceError> ServiceCall<R, E> New(Consumer<R> successCallback, Consumer<E> errorCallback) {
            return new Implementation<R, E>(successCallback, errorCallback);
        }

        public void success(R var1);

        public void error(E var1);

        public static class Implementation<R, E extends MobileServiceError>
        implements ServiceCall<R, E> {
            private final Consumer<R> successCallback;
            private final Consumer<E> errorCallback;

            public Implementation(Consumer<R> successCallback, Consumer<E> errorCallback) {
                this.successCallback = successCallback;
                this.errorCallback = errorCallback;
            }

            @Override
            public void success(R returnValue) {
                if (this.successCallback != null) {
                    this.successCallback.accept(returnValue);
                }
            }

            @Override
            public void error(E error) {
                if (this.errorCallback != null) {
                    this.errorCallback.accept(error);
                }
            }
        }
    }
}

