/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.accelerometer;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.accelerometer.Acceleration;
import com.xdev.mobile.service.accelerometer.AccelerationWatch;
import com.xdev.mobile.service.accelerometer.AccelerometerOptions;
import com.xdev.mobile.service.accelerometer.AccelerometerServiceAccess;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-device-motion", spec="1.2.2")})
@JavaScript(value={"accelerometer.js"})
public class AccelerometerService
extends AbstractMobileService
implements AccelerometerServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<Acceleration, MobileServiceError>> getCalls = new HashMap<String, AbstractMobileService.ServiceCall<Acceleration, MobileServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<AccelerationWatch, MobileServiceError>> watchCalls = new HashMap<String, AbstractMobileService.ServiceCall<AccelerationWatch, MobileServiceError>>();

    public static AccelerometerServiceAccess getInstance() {
        return AccelerometerService.getMobileService(AccelerometerService.class);
    }

    public AccelerometerService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("accelerometer_get_success", (JavaScriptFunction & Serializable)jsonArray -> this.accelerometer_get_success(jsonArray));
        this.addFunction("accelerometer_get_error", (JavaScriptFunction & Serializable)jsonArray -> this.accelerometer_get_error(jsonArray));
        this.addFunction("accelerometer_watch_success", (JavaScriptFunction & Serializable)jsonArray -> this.accelerometer_watch_success(jsonArray));
        this.addFunction("accelerometer_watch_error", (JavaScriptFunction & Serializable)jsonArray -> this.accelerometer_watch_error(jsonArray));
    }

    @Override
    public synchronized void getCurrentAcceleration(Consumer<Acceleration> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Acceleration, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.getCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("accelerometer_get(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void accelerometer_get_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Acceleration, MobileServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Acceleration acceleration = (Acceleration)new Gson().fromJson(jsonObject.toJson(), Acceleration.class);
            call.success(acceleration);
        }
    }

    private void accelerometer_get_error(JsonArray arguments) {
        this.callError(arguments, this.getCalls, true);
    }

    @Override
    public synchronized void watchAcceleration(AccelerometerOptions options, Consumer<AccelerationWatch> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<AccelerationWatch, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.watchCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("accelerometer_watch(").append(this.toLiteral(id)).append(",");
        js.append(this.toJson(options));
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private String toJson(AccelerometerOptions options) {
        return "{frequency:" + options.getFrequency() + "}";
    }

    private void accelerometer_watch_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<AccelerationWatch, MobileServiceError> call = this.watchCalls.get(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Acceleration acceleration = (Acceleration)new Gson().fromJson(jsonObject.toJson(), Acceleration.class);
            String watchID = arguments.getString(2);
            AccelerationWatch watch = new AccelerationWatch(acceleration, watchID);
            call.success(watch);
        }
    }

    private void accelerometer_watch_error(JsonArray arguments) {
        this.callError(arguments, this.watchCalls, false);
    }

    @Override
    public void clearWatch(String watchID) {
        StringBuilder js = new StringBuilder();
        js.append("accelerometer_clear_watch(");
        js.append(this.toLiteral(watchID)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }
}

