/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.app;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.app.AppEvent;
import com.xdev.mobile.service.app.AppEventHandler;
import com.xdev.mobile.service.app.AppServiceAccess;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@MobileService(plugins={@Plugin(name="cordova-plugin-exitapp", spec="1.0.0")})
@JavaScript(value={"app.js"})
public class AppService
extends AbstractMobileService
implements AppServiceAccess {
    private final List<AppEventHandler> pauseHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> resumeHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> backButtonHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> menuButtonHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> searchButtonHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> volumeDownButtonHandlers = new ArrayList<AppEventHandler>();
    private final List<AppEventHandler> volumeUpButtonHandlers = new ArrayList<AppEventHandler>();

    public static AppServiceAccess getInstance() {
        return AppService.getMobileService(AppService.class);
    }

    public AppService(AbstractClientConnector target, MobileServiceConfiguration configuration) {
        super(target, configuration);
        this.addFunction("app_onPause", (JavaScriptFunction & Serializable)jsonArray -> this.app_onPause(jsonArray));
        this.addFunction("app_onResume", (JavaScriptFunction & Serializable)jsonArray -> this.app_onResume(jsonArray));
        this.addFunction("app_onBackButton", (JavaScriptFunction & Serializable)jsonArray -> this.app_onBackButton(jsonArray));
        this.addFunction("app_onMenuButton", (JavaScriptFunction & Serializable)jsonArray -> this.app_onMenuButton(jsonArray));
        this.addFunction("app_onSearchButton", (JavaScriptFunction & Serializable)jsonArray -> this.app_onSearchButton(jsonArray));
        this.addFunction("app_onVolumeDownButton", (JavaScriptFunction & Serializable)jsonArray -> this.app_onVolumeDownButton(jsonArray));
        this.addFunction("app_onVolumeUpButton", (JavaScriptFunction & Serializable)jsonArray -> this.app_onVolumeUpButton(jsonArray));
    }

    @Override
    public void closeApp() {
        Page.getCurrent().getJavaScript().execute("app_closeApp()");
    }

    @Override
    public void addPauseHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.pauseHandlers, "app_addPauseHandler()");
    }

    @Override
    public void removePauseHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.pauseHandlers, "app_removePauseHandler()");
    }

    @Override
    public void addResumeHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.resumeHandlers, "app_addResumeHandler()");
    }

    @Override
    public void removeResumeHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.resumeHandlers, "app_removeResumeHandler()");
    }

    @Override
    public void addBackButtonHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.backButtonHandlers, "app_addBackButtonHandler()");
    }

    @Override
    public void removeBackButtonHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.backButtonHandlers, "app_removeBackButtonHandler()");
    }

    @Override
    public void addMenuButtonHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.menuButtonHandlers, "app_addMenuButtonHandler()");
    }

    @Override
    public void removeMenuButtonHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.menuButtonHandlers, "app_removeMenuButtonHandler()");
    }

    @Override
    public void addSearchButtonHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.searchButtonHandlers, "app_addSearchButtonHandler()");
    }

    @Override
    public void removeSearchButtonHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.searchButtonHandlers, "app_removeSearchButtonHandler()");
    }

    @Override
    public void addVolumeDownButtonHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.volumeDownButtonHandlers, "app_addVolumeDownButtonHandler()");
    }

    @Override
    public void removeVolumeDownButtonHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.volumeDownButtonHandlers, "app_removeVolumeDownButtonHandler()");
    }

    @Override
    public void addVolumeUpButtonHandler(AppEventHandler handler) {
        this.addEventHandler(handler, this.volumeUpButtonHandlers, "app_addVolumeUpButtonHandler()");
    }

    @Override
    public void removeVolumeUpButtonHandler(AppEventHandler handler) {
        this.removeEventHandler(handler, this.volumeUpButtonHandlers, "app_removeVolumeUpButtonHandler()");
    }

    private void addEventHandler(AppEventHandler handler, List<AppEventHandler> list, String javaScript) {
        if (list.isEmpty()) {
            Page.getCurrent().getJavaScript().execute(javaScript);
        }
        list.add(handler);
    }

    private void removeEventHandler(AppEventHandler handler, List<AppEventHandler> list, String javaScript) {
        list.remove(handler);
        if (list.isEmpty()) {
            Page.getCurrent().getJavaScript().execute(javaScript);
        }
    }

    private void app_onPause(JsonArray arguments) {
        this.handleEvent(this.pauseHandlers);
    }

    private void app_onResume(JsonArray arguments) {
        this.handleEvent(this.resumeHandlers);
    }

    private void app_onBackButton(JsonArray arguments) {
        this.handleEvent(this.backButtonHandlers);
    }

    private void app_onMenuButton(JsonArray arguments) {
        this.handleEvent(this.menuButtonHandlers);
    }

    private void app_onSearchButton(JsonArray arguments) {
        this.handleEvent(this.searchButtonHandlers);
    }

    private void app_onVolumeDownButton(JsonArray arguments) {
        this.handleEvent(this.volumeDownButtonHandlers);
    }

    private void app_onVolumeUpButton(JsonArray arguments) {
        this.handleEvent(this.volumeUpButtonHandlers);
    }

    private void handleEvent(List<AppEventHandler> handlers) {
        if (handlers.isEmpty()) {
            return;
        }
        AppEvent event = new AppEvent(this);
        int i = handlers.size();
        while (--i >= 0) {
            handlers.get(i).handleAppEvent(event);
            if (event.isConsumed()) break;
        }
    }
}

