/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.barcodescanner;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.barcodescanner.BarcodeData;
import com.xdev.mobile.service.barcodescanner.BarcodeFormat;
import com.xdev.mobile.service.barcodescanner.BarcodescannerOptions;
import com.xdev.mobile.service.barcodescanner.BarcodescannerServiceAccess;
import com.xdev.mobile.service.barcodescanner.Orientation;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@MobileService(plugins={@Plugin(name="phonegap-plugin-barcodescanner", spec="6.0.3")})
@JavaScript(value={"barcodescanner.js"})
public class BarcodescannerService
extends AbstractMobileService
implements BarcodescannerServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<BarcodeData, MobileServiceError>> scanCalls = new HashMap<String, AbstractMobileService.ServiceCall<BarcodeData, MobileServiceError>>();

    public static BarcodescannerServiceAccess getInstance() {
        return BarcodescannerService.getMobileService(BarcodescannerService.class);
    }

    public BarcodescannerService(AbstractClientConnector target, MobileServiceConfiguration configuration) {
        super(target, configuration);
        this.addFunction("barcodescanner_scan_success", (JavaScriptFunction & Serializable)jsonArray -> this.barcodescanner_scan_success(jsonArray));
        this.addFunction("barcodescanner_scan_error", (JavaScriptFunction & Serializable)jsonArray -> this.barcodescanner_scan_error(jsonArray));
    }

    @Override
    public synchronized void scan(BarcodescannerOptions options, Consumer<BarcodeData> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<BarcodeData, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.scanCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("barcodescanner_scan(").append(this.toLiteral(id)).append(",");
        js.append(this.toJson(options));
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private String toJson(BarcodescannerOptions options) {
        Orientation orientation;
        List<BarcodeFormat> formats;
        String prompt;
        Boolean showFlipCameraButton;
        ArrayList<String> list = new ArrayList<String>();
        Boolean preferFrontCamera = options.getPreferFrontCamera();
        if (preferFrontCamera != null) {
            list.add("preferFrontCamera:" + preferFrontCamera);
        }
        if ((showFlipCameraButton = options.getShowFlipCameraButton()) != null) {
            list.add("showFlipCameraButton:" + showFlipCameraButton);
        }
        if ((prompt = options.getPrompt()) != null) {
            list.add("prompt:" + this.toLiteral(prompt));
        }
        if (!(formats = options.getFormats()).isEmpty()) {
            list.add("formats:" + this.toLiteral(formats.stream().map(Enum::name).collect(Collectors.joining(","))));
        }
        if ((orientation = options.getOrientation()) != null) {
            list.add("orientation:" + orientation.getValue());
        }
        return list.stream().collect(Collectors.joining(",", "{", "}"));
    }

    private void barcodescanner_scan_success(JsonArray arguments) {
        JsonObject object;
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<BarcodeData, MobileServiceError> call = this.scanCalls.remove(id);
        if (call != null && !this.isCancelled(object = arguments.getObject(1))) {
            BarcodeFormat barcodeFormat;
            String format = object.getString("format");
            try {
                barcodeFormat = BarcodeFormat.valueOf(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                barcodeFormat = BarcodeFormat.UNKNOWN;
            }
            String text = object.getString("text");
            BarcodeData barcodeData = new BarcodeData(barcodeFormat, text);
            call.success(barcodeData);
        }
    }

    private boolean isCancelled(JsonObject object) {
        String cancelled = object.get("cancelled").asString();
        return "1".equals(cancelled) || "true".equalsIgnoreCase(cancelled);
    }

    private void barcodescanner_scan_error(JsonArray arguments) {
        this.callError(arguments, this.scanCalls, true);
    }
}

