/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.camera;

import com.xdev.mobile.service.camera.DestinationType;
import com.xdev.mobile.service.camera.Direction;
import com.xdev.mobile.service.camera.EncodingType;
import com.xdev.mobile.service.camera.MediaType;
import com.xdev.mobile.service.camera.PictureSourceType;

public class CameraOptions {
    private int quality = 50;
    private DestinationType destinationType = DestinationType.FILE_URI;
    private PictureSourceType sourceType = PictureSourceType.CAMERA;
    private final boolean allowEdit = false;
    private EncodingType encodingType = EncodingType.JPEG;
    private Integer targetWidth = null;
    private Integer targetHeight = null;
    private MediaType mediaType = MediaType.PICTURE;
    private boolean correctOrientation = false;
    private boolean saveToPhotoAlbum = false;
    private Direction direction = Direction.BACK;

    public static CameraOptions takeAndReturnPicture() {
        return new CameraOptions().mediaType(MediaType.PICTURE).destinationType(DestinationType.IMAGE).correctOrientation();
    }

    public int getQuality() {
        return this.quality;
    }

    public CameraOptions quality(int quality) {
        this.quality = quality;
        return this;
    }

    public CameraOptions destinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    public CameraOptions sourceType(PictureSourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public CameraOptions encodingType(EncodingType encodingType) {
        this.encodingType = encodingType;
        return this;
    }

    public CameraOptions targetSize(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
        return this;
    }

    public CameraOptions mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public CameraOptions correctOrientation() {
        this.correctOrientation = true;
        return this;
    }

    public CameraOptions saveToPhotoAlbum() {
        this.saveToPhotoAlbum = true;
        return this;
    }

    public CameraOptions direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public PictureSourceType getSourceType() {
        return this.sourceType;
    }

    public boolean isAllowEdit() {
        return false;
    }

    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    public Integer getTargetWidth() {
        return this.targetWidth;
    }

    public Integer getTargetHeight() {
        return this.targetHeight;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean isCorrectOrientation() {
        return this.correctOrientation;
    }

    public boolean isSaveToPhotoAlbum() {
        return this.saveToPhotoAlbum;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

