/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.camera;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.camera.CameraOptions;
import com.xdev.mobile.service.camera.CameraServiceAccess;
import com.xdev.mobile.service.camera.ImageData;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-camera", spec="2.3.0")})
@JavaScript(value={"camera.js"})
public class CameraService
extends AbstractMobileService
implements CameraServiceAccess {
    private final Map<String, GetPictureServiceCall> getPictureCalls = new HashMap<String, GetPictureServiceCall>();

    public static CameraServiceAccess getInstance() {
        return CameraService.getMobileService(CameraService.class);
    }

    public CameraService(AbstractClientConnector target, MobileServiceConfiguration configuration) {
        super(target, configuration);
        this.addFunction("camera_getPicture_success", (JavaScriptFunction & Serializable)jsonArray -> this.camera_getPicture_success(jsonArray));
        this.addFunction("camera_getPicture_error", (JavaScriptFunction & Serializable)jsonArray -> this.camera_getPicture_error(jsonArray));
    }

    @Override
    public synchronized void getPicture(CameraOptions options, Consumer<ImageData> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        GetPictureServiceCall call = new GetPictureServiceCall(successCallback, errorCallback, options);
        this.getPictureCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("camera_getPicture(").append(this.toLiteral(id)).append(",");
        this.appendOptions(js, options);
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void appendOptions(StringBuilder js, CameraOptions options) {
        js.append("{\n");
        js.append("quality: ").append(options.getQuality()).append(",\n");
        js.append("destinationType: Camera.DestinationType.").append(options.getDestinationType().getFieldName()).append(",\n");
        js.append("sourceType: Camera.PictureSourceType.").append(options.getSourceType().getFieldName()).append(",\n");
        js.append("allowEdit: ").append(options.isAllowEdit()).append(",\n");
        js.append("encodingType: Camera.EncodingType.").append((Object)options.getEncodingType()).append(",\n");
        Integer targetWidth = options.getTargetWidth();
        Integer targetHeight = options.getTargetHeight();
        if (targetWidth != null && targetHeight != null) {
            js.append("targetWidth: ").append(targetWidth).append(",\n");
            js.append("targetHeight: ").append(targetHeight).append(",\n");
        }
        js.append("mediaType: Camera.MediaType.").append((Object)options.getMediaType()).append(",\n");
        js.append("correctOrientation: ").append(options.isCorrectOrientation()).append(",\n");
        js.append("saveToPhotoAlbum: ").append(options.isSaveToPhotoAlbum()).append(",\n");
        js.append("cameraDirection: Camera.Direction.").append((Object)options.getDirection()).append("\n}");
    }

    private void camera_getPicture_success(JsonArray arguments) {
        String id = arguments.getString(0);
        GetPictureServiceCall call = this.getPictureCalls.remove(id);
        if (call != null) {
            ImageData imageData = new ImageData(call.getOptions(), arguments.getString(1));
            call.success(imageData);
        }
    }

    private void camera_getPicture_error(JsonArray arguments) {
        this.callError(arguments, this.getPictureCalls, true);
    }

    protected static class GetPictureServiceCall
    extends AbstractMobileService.ServiceCall.Implementation<ImageData, MobileServiceError> {
        private final CameraOptions options;

        public GetPictureServiceCall(Consumer<ImageData> successCallback, Consumer<MobileServiceError> errorCallback, CameraOptions options) {
            super(successCallback, errorCallback);
            this.options = options;
        }

        public CameraOptions getOptions() {
            return this.options;
        }
    }
}

