/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.camera;

import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.xdev.mobile.service.camera.CameraOptions;
import com.xdev.mobile.service.camera.DestinationType;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Base64;

public class ImageData {
    private String base64data;
    private String uri;

    ImageData(CameraOptions options, String value) {
        if (options.getDestinationType() == DestinationType.IMAGE) {
            this.base64data = value;
        } else {
            this.uri = value;
        }
    }

    public String getBase64data() {
        return this.base64data;
    }

    public byte[] toRawData() {
        if (this.base64data == null) {
            throw new IllegalArgumentException("ImageData contains only URI");
        }
        return Base64.getDecoder().decode(this.base64data);
    }

    public Resource toResource() {
        if (this.base64data == null) {
            throw new IllegalArgumentException("ImageData contains only URI");
        }
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(this.toRawData()), this.toString());
    }

    public String getURI() {
        return this.uri;
    }
}

