/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.compass;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.compass.CompassOptions;
import com.xdev.mobile.service.compass.CompassServiceAccess;
import com.xdev.mobile.service.compass.CompassServiceError;
import com.xdev.mobile.service.compass.Heading;
import com.xdev.mobile.service.compass.HeadingWatch;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-device-orientation", spec="1.0.4")})
@JavaScript(value={"compass.js"})
public class CompassService
extends AbstractMobileService
implements CompassServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<Heading, CompassServiceError>> getCalls = new HashMap<String, AbstractMobileService.ServiceCall<Heading, CompassServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<HeadingWatch, CompassServiceError>> watchCalls = new HashMap<String, AbstractMobileService.ServiceCall<HeadingWatch, CompassServiceError>>();

    public static CompassServiceAccess getInstance() {
        return CompassService.getMobileService(CompassService.class);
    }

    public CompassService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("compass_get_success", (JavaScriptFunction & Serializable)jsonArray -> this.compass_get_success(jsonArray));
        this.addFunction("compass_get_error", (JavaScriptFunction & Serializable)jsonArray -> this.compass_get_error(jsonArray));
        this.addFunction("compass_watch_success", (JavaScriptFunction & Serializable)jsonArray -> this.compass_watch_success(jsonArray));
        this.addFunction("compass_watch_error", (JavaScriptFunction & Serializable)jsonArray -> this.compass_watch_error(jsonArray));
    }

    @Override
    public synchronized void getCurrentHeading(Consumer<Heading> successCallback, Consumer<CompassServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Heading, CompassServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.getCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("compass_get(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void compass_get_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Heading, CompassServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Heading heading = (Heading)new Gson().fromJson(jsonObject.toJson(), Heading.class);
            call.success(heading);
        }
    }

    private void compass_get_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Heading, CompassServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            call.error(this.createGeolocationServiceError((JsonObject)arguments.get(1)));
        }
    }

    @Override
    public synchronized void watchHeading(CompassOptions options, Consumer<HeadingWatch> successCallback, Consumer<CompassServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<HeadingWatch, CompassServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.watchCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("compass_watch(").append(this.toLiteral(id)).append(",");
        js.append(this.toJson(options));
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private String toJson(CompassOptions options) {
        return "{frequency:" + options.getFrequency() + "}";
    }

    private void compass_watch_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<HeadingWatch, CompassServiceError> call = this.watchCalls.get(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Heading heading = (Heading)new Gson().fromJson(jsonObject.toJson(), Heading.class);
            String watchID = arguments.getString(2);
            HeadingWatch watch = new HeadingWatch(heading, watchID);
            call.success(watch);
        }
    }

    private void compass_watch_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<HeadingWatch, CompassServiceError> call = this.watchCalls.remove(id);
        if (call != null) {
            call.error(this.createGeolocationServiceError((JsonObject)arguments.get(1)));
        }
    }

    @Override
    public void clearWatch(String watchID) {
        StringBuilder js = new StringBuilder();
        js.append("compass_clear_watch(");
        js.append(this.toLiteral(watchID)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private CompassServiceError createGeolocationServiceError(JsonObject error) {
        CompassServiceError.Reason reason = null;
        try {
            reason = CompassServiceError.Reason.getByCode((int)error.getNumber("code"));
        }
        catch (Exception exception) {}
        return new CompassServiceError(this, "", reason);
    }
}

