/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.contacts;

import com.xdev.mobile.service.contacts.ContactFieldType;

public class ContactFindOptions {
    private String filter = "";
    private ContactFieldType[] filterFields;
    private boolean multiple = true;
    private boolean mustHavePhoneNumber = false;
    private ContactFieldType[] desiredFields;

    public static ContactFindOptions all() {
        return new ContactFindOptions().multipleResults();
    }

    public static ContactFindOptions byName(String name) {
        return new ContactFindOptions().filter(name, ContactFieldType.DISPLAY_NAME, ContactFieldType.NAME, ContactFieldType.FAMILY_NAME, ContactFieldType.GIVEN_NAME).multipleResults();
    }

    public static ContactFindOptions byPhoneNumber(String number) {
        return new ContactFindOptions().filter(number, ContactFieldType.PHONE_NUMBERS).multipleResults();
    }

    public ContactFindOptions filter(String filter, ContactFieldType ... filterFields) {
        this.filter = filter;
        this.filterFields = filterFields;
        return this;
    }

    public ContactFindOptions singleResult() {
        this.multiple = false;
        return this;
    }

    public ContactFindOptions multipleResults() {
        this.multiple = true;
        return this;
    }

    public ContactFindOptions mustHavePhoneNumer() {
        this.mustHavePhoneNumber = true;
        return this;
    }

    public ContactFindOptions returnFields(ContactFieldType ... fieldTypes) {
        this.desiredFields = fieldTypes;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public ContactFieldType[] getFilterFields() {
        return this.filterFields;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isMustHavePhoneNumber() {
        return this.mustHavePhoneNumber;
    }

    public ContactFieldType[] getDesiredFields() {
        return this.desiredFields;
    }
}

