/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.contacts;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.contacts.Contact;
import com.xdev.mobile.service.contacts.ContactFieldType;
import com.xdev.mobile.service.contacts.ContactFindOptions;
import com.xdev.mobile.service.contacts.ContactsServiceAccess;
import com.xdev.mobile.service.contacts.ContactsServiceError;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-contacts", spec="2.2.0")})
@JavaScript(value={"contacts.js"})
public class ContactsService
extends AbstractMobileService
implements ContactsServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<List<Contact>, ContactsServiceError>> findCalls = new HashMap<String, AbstractMobileService.ServiceCall<List<Contact>, ContactsServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<Contact, ContactsServiceError>> pickCalls = new HashMap<String, AbstractMobileService.ServiceCall<Contact, ContactsServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<Contact, ContactsServiceError>> saveCalls = new HashMap<String, AbstractMobileService.ServiceCall<Contact, ContactsServiceError>>();

    public static ContactsServiceAccess getInstance() {
        return ContactsService.getMobileService(ContactsService.class);
    }

    public ContactsService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("contacts_find_success", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_find_success(jsonArray));
        this.addFunction("contacts_find_error", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_find_error(jsonArray));
        this.addFunction("contacts_pick_success", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_pick_success(jsonArray));
        this.addFunction("contacts_pick_error", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_pick_error(jsonArray));
        this.addFunction("contacts_save_success", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_save_success(jsonArray));
        this.addFunction("contacts_save_error", (JavaScriptFunction & Serializable)jsonArray -> this.contacts_save_error(jsonArray));
    }

    @Override
    public synchronized void find(ContactFindOptions options, Consumer<List<Contact>> successCallback, Consumer<ContactsServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<List<Contact>, ContactsServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.findCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        this.appendFields(js, options);
        this.appendOptions(js, options);
        js.append("contacts_find(").append(this.toLiteral(id)).append(",fields,options);");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void appendFields(StringBuilder js, ContactFindOptions options) {
        js.append("var fields = [");
        ContactFieldType[] filterFields = options.getFilterFields();
        if (filterFields == null || filterFields.length == 0) {
            js.append("'*'");
        } else {
            int i = 0;
            while (i < filterFields.length) {
                if (i > 0) {
                    js.append(",");
                }
                js.append("navigator.contacts.fieldType.");
                js.append(filterFields[i].getFieldName());
                ++i;
            }
        }
        js.append("];\n");
    }

    private void appendOptions(StringBuilder js, ContactFindOptions options) {
        js.append("var options = new ContactFindOptions();\n");
        js.append("options.filter = '").append(options.getFilter().replace("'", "\\'")).append("';\n");
        js.append("options.multiple = ").append(options.isMultiple()).append(";\n");
        js.append("options.hasPhoneNumber = ").append(options.isMustHavePhoneNumber()).append(";\n");
        ContactFieldType[] desiredFields = options.getDesiredFields();
        if (desiredFields != null && desiredFields.length > 0) {
            js.append("options.desiredFields = [");
            int i = 0;
            while (i < desiredFields.length) {
                if (i > 0) {
                    js.append(",");
                }
                js.append("navigator.contacts.fieldType.");
                js.append(desiredFields[i].getFieldName());
                ++i;
            }
            js.append("];\n");
        }
    }

    private void contacts_find_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<List<Contact>, ContactsServiceError> call = this.findCalls.remove(id);
        if (call != null) {
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            JsonArray arrayData = (JsonArray)arguments.get(1);
            int i = 0;
            while (i < arrayData.length()) {
                Gson gson = new Gson();
                JsonObject jsonObject = (JsonObject)arrayData.get(i);
                Contact contact = (Contact)gson.fromJson(jsonObject.toJson(), Contact.class);
                contacts.add(contact);
                ++i;
            }
            call.success(contacts);
        }
    }

    private void contacts_find_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<List<Contact>, ContactsServiceError> call = this.findCalls.remove(id);
        if (call != null) {
            call.error(this.createContactsServiceError(arguments.get(1).asString()));
        }
    }

    @Override
    public void pickContact(Consumer<Contact> successCallback, Consumer<ContactsServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.pickCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("contacts_pick(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void contacts_pick_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = this.pickCalls.remove(id);
        if (call != null) {
            Gson gson = new Gson();
            JsonObject jsonObject = arguments.getObject(1);
            Contact contact = (Contact)gson.fromJson(jsonObject.toJson(), Contact.class);
            call.success(contact);
        }
    }

    private void contacts_pick_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = this.pickCalls.remove(id);
        if (call != null) {
            call.error(this.createContactsServiceError(arguments.get(1).asString()));
        }
    }

    @Override
    public void save(Contact contact, Consumer<Contact> successCallback, Consumer<ContactsServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.saveCalls.put(id, call);
        Gson gson = new Gson();
        String json = gson.toJson((Object)contact);
        StringBuilder js = new StringBuilder();
        js.append("contacts_save(").append(this.toLiteral(id)).append(",").append(json).append(")");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void contacts_save_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = this.saveCalls.remove(id);
        if (call != null) {
            Gson gson = new Gson();
            JsonObject jsonObject = arguments.getObject(1);
            Contact contact = (Contact)gson.fromJson(jsonObject.toJson(), Contact.class);
            call.success(contact);
        }
    }

    private void contacts_save_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Contact, ContactsServiceError> call = this.saveCalls.remove(id);
        if (call != null) {
            call.error(this.createContactsServiceError(arguments.get(1).asString()));
        }
    }

    private ContactsServiceError createContactsServiceError(String message) {
        ContactsServiceError.Reason reason = null;
        try {
            int code = Integer.parseInt(message);
            reason = ContactsServiceError.Reason.getByCode(code);
        }
        catch (Exception exception) {}
        return new ContactsServiceError(this, message, reason);
    }
}

