/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.deviceinfo;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.deviceinfo.DeviceInfo;
import com.xdev.mobile.service.deviceinfo.DeviceInfoServiceAccess;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-device", spec="1.1.3")})
@JavaScript(value={"deviceinfo.js"})
public class DeviceInfoService
extends AbstractMobileService
implements DeviceInfoServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<DeviceInfo, MobileServiceError>> getCalls = new HashMap<String, AbstractMobileService.ServiceCall<DeviceInfo, MobileServiceError>>();

    public static DeviceInfoServiceAccess getInstance() {
        return DeviceInfoService.getMobileService(DeviceInfoService.class);
    }

    public DeviceInfoService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("deviceinfo_callback", (JavaScriptFunction & Serializable)jsonArray -> this.deviceinfo_callback(jsonArray));
    }

    @Override
    public void getDeviceInfo(Consumer<DeviceInfo> callback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall call = AbstractMobileService.ServiceCall.New(callback, null);
        this.getCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("deviceinfo_get(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void deviceinfo_callback(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<DeviceInfo, MobileServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            Gson gson = new Gson();
            JsonObject jsonObject = arguments.getObject(1);
            DeviceInfo info = (DeviceInfo)gson.fromJson(jsonObject.toJson(), DeviceInfo.class);
            call.success(info);
        }
    }
}

