/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.file;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.file.FileData;
import com.xdev.mobile.service.file.FileServiceAccess;
import com.xdev.mobile.service.file.FileServiceError;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-plugin-file", spec="4.2.0")})
@JavaScript(value={"file.js"})
public class FileService
extends AbstractMobileService
implements FileServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<FileData, FileServiceError>> readFileCalls = new HashMap<String, AbstractMobileService.ServiceCall<FileData, FileServiceError>>();

    public static FileServiceAccess getInstance() {
        return FileService.getMobileService(FileService.class);
    }

    public FileService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("file_readFile_success", (JavaScriptFunction & Serializable)jsonArray -> this.file_readFile_success(jsonArray));
        this.addFunction("file_readFile_error", (JavaScriptFunction & Serializable)jsonArray -> this.file_readFile_error(jsonArray));
    }

    @Override
    public void readFile(String path, Consumer<FileData> successCallback, Consumer<FileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<FileData, FileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.readFileCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("file_readFile(").append(this.toLiteral(id)).append(",").append(this.toLiteral(path)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void file_readFile_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<FileData, FileServiceError> call = this.readFileCalls.remove(id);
        if (call != null) {
            call.success(new FileData(arguments.get(1).asString()));
        }
    }

    private void file_readFile_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<FileData, FileServiceError> call = this.readFileCalls.remove(id);
        if (call != null) {
            call.error(this.createFileServiceError("Error reading file", arguments.get(1)));
        }
    }

    private FileServiceError createFileServiceError(String message, JsonValue value) {
        FileServiceError.Reason reason = null;
        if (value instanceof JsonObject) {
            try {
                int code = (int)((JsonObject)value).getNumber("code");
                reason = FileServiceError.Reason.getByCode(code);
            }
            catch (Exception exception) {}
        }
        return new FileServiceError(this, message, reason);
    }
}

