/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.geolocation;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.geolocation.Coordinates;
import com.xdev.mobile.service.geolocation.GeolocationOptions;
import com.xdev.mobile.service.geolocation.GeolocationServiceAccess;
import com.xdev.mobile.service.geolocation.GeolocationServiceError;
import com.xdev.mobile.service.geolocation.Position;
import com.xdev.mobile.service.geolocation.PositionWatch;
import elemental.json.JsonArray;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@MobileService(plugins={@Plugin(name="cordova-plugin-geolocation", spec="2.4.0")})
@JavaScript(value={"geolocation.js"})
public class GeolocationService
extends AbstractMobileService
implements GeolocationServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<Position, GeolocationServiceError>> getCalls = new HashMap<String, AbstractMobileService.ServiceCall<Position, GeolocationServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<PositionWatch, GeolocationServiceError>> watchCalls = new HashMap<String, AbstractMobileService.ServiceCall<PositionWatch, GeolocationServiceError>>();

    public static GeolocationServiceAccess getInstance() {
        return GeolocationService.getMobileService(GeolocationService.class);
    }

    public GeolocationService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("geolocation_get_success", (JavaScriptFunction & Serializable)jsonArray -> this.geolocation_get_success(jsonArray));
        this.addFunction("geolocation_get_error", (JavaScriptFunction & Serializable)jsonArray -> this.geolocation_get_error(jsonArray));
        this.addFunction("geolocation_watch_success", (JavaScriptFunction & Serializable)jsonArray -> this.geolocation_watch_success(jsonArray));
        this.addFunction("geolocation_watch_error", (JavaScriptFunction & Serializable)jsonArray -> this.geolocation_watch_error(jsonArray));
    }

    @Override
    public synchronized void getCurrentPosition(GeolocationOptions options, Consumer<Position> successCallback, Consumer<GeolocationServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Position, GeolocationServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.getCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("geolocation_get(").append(this.toLiteral(id)).append(",");
        js.append(this.toJson(options));
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void geolocation_get_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Position, GeolocationServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Position position = this.parsePosition(jsonObject);
            call.success(position);
        }
    }

    private void geolocation_get_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Position, GeolocationServiceError> call = this.getCalls.remove(id);
        if (call != null) {
            call.error(this.createGeolocationServiceError((JsonObject)arguments.get(1)));
        }
    }

    @Override
    public synchronized void watchPosition(GeolocationOptions options, Consumer<PositionWatch> successCallback, Consumer<GeolocationServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<PositionWatch, GeolocationServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.watchCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("geolocation_watch(").append(this.toLiteral(id)).append(",");
        js.append(this.toJson(options));
        js.append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private String toJson(GeolocationOptions options) {
        Long maximumAge;
        Long timeout;
        ArrayList<String> list = new ArrayList<String>();
        Boolean enableHighAccuracy = options.getEnableHighAccuracy();
        if (enableHighAccuracy != null) {
            list.add("enableHighAccuracy:" + enableHighAccuracy);
        }
        if ((timeout = options.getTimeout()) != null) {
            list.add("timeout:" + timeout);
        }
        if ((maximumAge = options.getMaximumAge()) != null) {
            list.add("maximumAge:" + maximumAge);
        }
        return list.stream().collect(Collectors.joining(",", "{", "}"));
    }

    private void geolocation_watch_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<PositionWatch, GeolocationServiceError> call = this.watchCalls.get(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Position position = this.parsePosition(jsonObject);
            String watchID = arguments.getString(2);
            PositionWatch watch = new PositionWatch(position, watchID);
            call.success(watch);
        }
    }

    private void geolocation_watch_error(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<PositionWatch, GeolocationServiceError> call = this.watchCalls.remove(id);
        if (call != null) {
            call.error(this.createGeolocationServiceError((JsonObject)arguments.get(1)));
        }
    }

    @Override
    public void clearWatch(String watchID) {
        StringBuilder js = new StringBuilder();
        js.append("geolocation_clear_watch(");
        js.append(this.toLiteral(watchID)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private Position parsePosition(JsonObject object) {
        JsonObject coordsObj = object.getObject("coords");
        Coordinates coords = new Coordinates(this.getDouble(coordsObj, "latitude"), this.getDouble(coordsObj, "longitude"), this.getDouble(coordsObj, "altitude"), this.getDouble(coordsObj, "accuracy"), this.getDouble(coordsObj, "altitudeAccuracy"), this.getDouble(coordsObj, "heading"), this.getDouble(coordsObj, "speed"));
        long timestamp = (long)this.getDouble(object, "timestamp");
        return new Position(coords, timestamp);
    }

    private double getDouble(JsonObject object, String key) {
        JsonValue value;
        if (object.hasKey(key) && (value = object.get(key)) instanceof JsonNumber) {
            return value.asNumber();
        }
        return -1.0;
    }

    private GeolocationServiceError createGeolocationServiceError(JsonObject error) {
        String message = "";
        GeolocationServiceError.Reason reason = null;
        try {
            message = error.getString("message");
        }
        catch (Exception exception) {}
        try {
            reason = GeolocationServiceError.Reason.getByCode((int)error.getNumber("code"));
        }
        catch (Exception exception) {}
        return new GeolocationServiceError(this, message, reason);
    }
}

