/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.nfc;

import com.google.gson.Gson;
import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.nfc.Ndef;
import com.xdev.mobile.service.nfc.NfcServiceAccess;
import com.xdev.mobile.service.nfc.Record;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="phonegap-nfc", spec="0.6.6")})
@JavaScript(value={"nfc.js"})
public class NfcService
extends AbstractMobileService
implements NfcServiceAccess {
    private final Map<String, NfcCallbackServiceCall> startNdefListenerCalls = new HashMap<String, NfcCallbackServiceCall>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> removeNdefListenerCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();
    private final Map<String, NfcCallbackServiceCall> startTagDiscoveredListenerCalls = new HashMap<String, NfcCallbackServiceCall>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> stopTagDiscoveredListenerCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> eraseTagCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> writeCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> makeReadOnlyCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();
    private final Map<String, AbstractMobileService.ServiceCall<String, MobileServiceError>> showSettingsCalls = new HashMap<String, AbstractMobileService.ServiceCall<String, MobileServiceError>>();

    public static NfcServiceAccess getInstance() {
        return NfcService.getMobileService(NfcService.class);
    }

    public NfcService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("nfc_startNdefListener_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startNdefListener_success(jsonArray));
        this.addFunction("nfc_startNdefListener_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startNdefListener_error(jsonArray));
        this.addFunction("nfc_startNdefListener_callback", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startNdefListener_callback(jsonArray));
        this.addFunction("nfc_stopNdefListener_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_stopNdefListener_success(jsonArray));
        this.addFunction("nfc_stopNdefListener_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_stopNdefListener_error(jsonArray));
        this.addFunction("nfc_startTagDiscoveredListener_callback", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startTagDiscoveredListener_callback(jsonArray));
        this.addFunction("nfc_startTagDiscoveredListener_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startTagDiscoveredListener_success(jsonArray));
        this.addFunction("nfc_startTagDiscoveredListener_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_startTagDiscoveredListener_error(jsonArray));
        this.addFunction("nfc_stopTagDiscoveredListener_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_stopTagDiscoveredListener_success(jsonArray));
        this.addFunction("nfc_stopTagDiscoveredListener_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_stopTagDiscoveredListener_error(jsonArray));
        this.addFunction("nfc_erase_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_erase_success(jsonArray));
        this.addFunction("nfc_erase_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_erase_error(jsonArray));
        this.addFunction("nfc_write_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_write_success(jsonArray));
        this.addFunction("nfc_write_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_write_error(jsonArray));
        this.addFunction("nfc_makeReadOnly_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_makeReadOnly_success(jsonArray));
        this.addFunction("nfc_makeReadOnly_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_makeReadOnly_error(jsonArray));
        this.addFunction("nfc_showSettings_success", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_showSettings_success(jsonArray));
        this.addFunction("nfc_showSettings_error", (JavaScriptFunction & Serializable)jsonArray -> this.nfc_showSettings_error(jsonArray));
    }

    @Override
    public synchronized void startNdefListener(Consumer<Ndef> callback, Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        this.removeAllListener();
        String id = this.generateCallerID();
        NfcCallbackServiceCall call = new NfcCallbackServiceCall(successCallback, errorCallback, callback);
        this.startNdefListenerCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_startNdefListener(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_startNdefListener_success(JsonArray arguments) {
        String id = arguments.getString(0);
        NfcCallbackServiceCall call = this.startNdefListenerCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_startNdefListener_error(JsonArray arguments) {
        this.callError(arguments, this.startNdefListenerCalls, true);
    }

    private void nfc_startNdefListener_callback(JsonArray arguments) {
        String id = arguments.getString(0);
        NfcCallbackServiceCall call = this.startNdefListenerCalls.get(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Ndef ndef = (Ndef)new Gson().fromJson(jsonObject.toJson(), Ndef.class);
            call.callback(ndef);
        }
    }

    @Override
    public synchronized void stopNdefListener(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.removeNdefListenerCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_stopNdefListener(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_stopNdefListener_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.removeNdefListenerCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_stopNdefListener_error(JsonArray arguments) {
        this.callError(arguments, this.removeNdefListenerCalls, true);
    }

    @Override
    public synchronized void startTagDiscoveredListener(Consumer<Ndef> callback, Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        this.removeAllListener();
        String id = this.generateCallerID();
        NfcCallbackServiceCall call = new NfcCallbackServiceCall(successCallback, errorCallback, callback);
        this.startTagDiscoveredListenerCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_startTagDiscoveredListener(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_startTagDiscoveredListener_success(JsonArray arguments) {
        String id = arguments.getString(0);
        NfcCallbackServiceCall call = this.startTagDiscoveredListenerCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_startTagDiscoveredListener_error(JsonArray arguments) {
        this.callError(arguments, this.startTagDiscoveredListenerCalls, true);
    }

    private void nfc_startTagDiscoveredListener_callback(JsonArray arguments) {
        String id = arguments.getString(0);
        NfcCallbackServiceCall call = this.startTagDiscoveredListenerCalls.get(id);
        if (call != null) {
            JsonObject jsonObject = arguments.getObject(1);
            Ndef ndef = (Ndef)new Gson().fromJson(jsonObject.toJson(), Ndef.class);
            call.callback(ndef);
        }
    }

    @Override
    public synchronized void stopTagDiscoveredListener(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.stopTagDiscoveredListenerCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_stopTagDiscoveredListener(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_stopTagDiscoveredListener_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.stopTagDiscoveredListenerCalls.remove(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_stopTagDiscoveredListener_error(JsonArray arguments) {
        this.callError(arguments, this.stopTagDiscoveredListenerCalls, true);
    }

    @Override
    public synchronized void eraseTag(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        this.removeAllListener();
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.eraseTagCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_erase_tag(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_erase_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.eraseTagCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_erase_error(JsonArray arguments) {
        this.callError(arguments, this.eraseTagCalls, true);
    }

    @Override
    public synchronized void write(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback, Record ... records) {
        if (records == null || records.length == 0) {
            throw new IllegalArgumentException("At least one record is required");
        }
        this.removeAllListener();
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.writeCalls.put(id, call);
        StringBuilder message = new StringBuilder();
        message.append("[");
        int i = 0;
        while (i < records.length) {
            if (i > 0) {
                message.append(",");
            }
            Record record = records[i];
            block0 : switch (record.getTypeNameFormat()) {
                case TNF_WELL_KNOWN: {
                    switch (record.getRecordType()) {
                        case RTD_TEXT: {
                            message.append("ndef.textRecord(").append(this.toLiteral(record.getPayloadAsString())).append(",null,").append(this.toLiteral(record.getIdAsString())).append(")");
                            break block0;
                        }
                        case RTD_URI: {
                            message.append("ndef.uriRecord(").append(this.toLiteral(record.getPayloadAsString())).append(",").append(this.toLiteral(record.getIdAsString())).append(")");
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported record");
                }
                case TNF_ABSOLUTE_URI: {
                    message.append("ndef.absoluteUriRecord(").append(this.toLiteral(record.getTypeAsString())).append(",").append(this.toLiteral(record.getPayloadAsString())).append(",").append(this.toLiteral(record.getIdAsString())).append(")");
                    break;
                }
                case TNF_MIME_MEDIA: {
                    message.append("ndef.mimeMediaRecord(").append(this.toLiteral(record.getTypeAsString())).append(",").append(this.toLiteral(record.getPayloadAsString())).append(",").append(this.toLiteral(record.getIdAsString())).append(")");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported record");
                }
            }
            ++i;
        }
        message.append("]");
        StringBuilder js = new StringBuilder();
        js.append("nfc_write(").append(this.toLiteral(id)).append(",").append((CharSequence)message).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_write_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.writeCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_write_error(JsonArray arguments) {
        this.callError(arguments, this.writeCalls, true);
    }

    @Override
    public synchronized void makeReadOnly(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        this.removeAllListener();
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.makeReadOnlyCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_makeReadOnly(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_makeReadOnly_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.makeReadOnlyCalls.get(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_makeReadOnly_error(JsonArray arguments) {
        this.callError(arguments, this.makeReadOnlyCalls, true);
    }

    @Override
    public synchronized void showSettings(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback) {
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = AbstractMobileService.ServiceCall.New(successCallback, errorCallback);
        this.showSettingsCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("nfc_showSettings(").append(this.toLiteral(id)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private void nfc_showSettings_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<String, MobileServiceError> call = this.showSettingsCalls.remove(id);
        if (call != null) {
            call.success(arguments.getString(1));
        }
    }

    private void nfc_showSettings_error(JsonArray arguments) {
        this.callError(arguments, this.showSettingsCalls, true);
    }

    @Override
    public synchronized void removeAllListener() {
        this.startNdefListenerCalls.clear();
        this.removeNdefListenerCalls.clear();
        this.startTagDiscoveredListenerCalls.clear();
        this.stopTagDiscoveredListenerCalls.clear();
        this.eraseTagCalls.clear();
        this.writeCalls.clear();
        this.makeReadOnlyCalls.clear();
        this.showSettingsCalls.clear();
        StringBuilder js = new StringBuilder();
        js.append("nfc_remove_all_Listener();");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    protected static class NfcCallbackServiceCall
    extends AbstractMobileService.ServiceCall.Implementation<String, MobileServiceError> {
        private final Consumer<Ndef> callback;

        public NfcCallbackServiceCall(Consumer<String> successCallback, Consumer<MobileServiceError> errorCallback, Consumer<Ndef> callback) {
            super(successCallback, errorCallback);
            this.callback = callback;
        }

        public void callback(Ndef ndef) {
            if (this.callback != null) {
                this.callback.accept(ndef);
            }
        }
    }
}

