/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.nfc;

import com.xdev.mobile.service.nfc.RecordType;
import com.xdev.mobile.service.nfc.TypeNameFormat;
import java.io.UnsupportedEncodingException;

public class Record {
    private static final String CHARSET_NAME = "UTF-8";
    private int tnf;
    private byte[] type;
    private byte[] id;
    private byte[] payload;

    public static Record textRecord(String text) {
        return Record.textRecord(text, null);
    }

    public static Record textRecord(String text, byte[] id) {
        try {
            return new Record(TypeNameFormat.TNF_WELL_KNOWN.getCode(), RecordType.RTD_TEXT.getData(), id, text.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Record uriRecord(String uri) {
        return Record.uriRecord(uri, null);
    }

    public static Record uriRecord(String uri, byte[] id) {
        try {
            return new Record(TypeNameFormat.TNF_WELL_KNOWN.getCode(), RecordType.RTD_URI.getData(), id, uri.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Record absoluteUriRecord(String uri, String payload) {
        return Record.absoluteUriRecord(uri, payload, null);
    }

    public static Record absoluteUriRecord(String uri, String payload, byte[] id) {
        try {
            return new Record(TypeNameFormat.TNF_ABSOLUTE_URI.getCode(), uri.getBytes(CHARSET_NAME), id, payload.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Record mimeMediaRecord(String mimeType, String payload) {
        return Record.mimeMediaRecord(mimeType, payload, null);
    }

    public static Record mimeMediaRecord(String mimeType, String payload, byte[] id) {
        try {
            return new Record(TypeNameFormat.TNF_MIME_MEDIA.getCode(), mimeType.getBytes(CHARSET_NAME), id, payload.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Record emptyRecord() {
        return new Record(TypeNameFormat.TNF_EMPTY.getCode(), null, null, null);
    }

    public static Record androidApplicationRecord(String packageName) {
        try {
            return new Record(TypeNameFormat.TNF_EXTERNAL_TYPE.getCode(), "android.com:pkg".getBytes(CHARSET_NAME), null, packageName.getBytes(CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Record() {
    }

    public Record(int tnf, byte[] type, byte[] id, byte[] payload) {
        this.tnf = tnf;
        this.type = type;
        this.id = id;
        this.payload = payload;
    }

    public int getTnf() {
        return this.tnf;
    }

    public TypeNameFormat getTypeNameFormat() {
        return TypeNameFormat.byNumber(this.tnf);
    }

    public void setTnf(int tnf) {
        this.tnf = tnf;
    }

    public void setTypeNameFormat(TypeNameFormat tnf) {
        this.tnf = tnf.getCode();
    }

    public byte[] getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == null) {
            return "";
        }
        try {
            return new String(this.type, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public RecordType getRecordType() {
        return RecordType.byData(this.type);
    }

    public void setType(byte[] type) {
        this.type = type;
    }

    public void setType(String type) {
        try {
            this.type = type.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setType(RecordType type) {
        this.type = type.getData();
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIdAsString() {
        if (this.id == null) {
            return "";
        }
        try {
            return new String(this.id, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public void setId(String id) {
        try {
            this.id = id.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadAsString() {
        try {
            return new String(this.payload, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setPayload(String payload) {
        try {
            this.payload = payload.getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "Record [tnf=" + this.tnf + ", type=" + this.getTypeAsString() + ", id=" + this.getIdAsString() + ", payload=" + this.getPayloadAsString() + "]";
    }
}

