/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.nfc;

import java.util.Arrays;

public enum RecordType {
    RTD_TEXT(84),
    RTD_URI(85),
    RTD_SMART_POSTER(83, 112),
    RTD_ALTERNATIVE_CARRIER(97, 99),
    RTD_HANDOVER_CARRIER(72, 99),
    RTD_HANDOVER_REQUEST(72, 114),
    RTD_HANDOVER_SELECT(72, 115);

    private byte[] data;

    public static RecordType byData(byte[] data) {
        return Arrays.stream(RecordType.values()).filter(rt -> Arrays.equals(rt.data, data)).findAny().orElseThrow(() -> new IllegalArgumentException("No RecordType for data: " + Arrays.toString(data)));
    }

    private RecordType(int ... data) {
        this.data = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            this.data[i] = (byte)data[i];
            ++i;
        }
    }

    public byte[] getData() {
        return this.data;
    }
}

