/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.nfc;

import java.util.Arrays;

public enum TypeNameFormat {
    TNF_EMPTY(0, "Empty"),
    TNF_WELL_KNOWN(1, "Well Known"),
    TNF_MIME_MEDIA(2, "Mime Media"),
    TNF_ABSOLUTE_URI(3, "Absolute URI"),
    TNF_EXTERNAL_TYPE(4, "External"),
    TNF_UNKNOWN(5, "Unknown"),
    TNF_UNCHANGED(6, "Unchanged"),
    TNF_RESERVED(7, "Reserved");

    private final int code;
    private final String description;

    public static TypeNameFormat byNumber(int code) {
        return Arrays.stream(TypeNameFormat.values()).filter(tnf -> tnf.getCode() == code).findAny().orElseThrow(() -> new IllegalArgumentException("No TNF for code: " + code));
    }

    private TypeNameFormat(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCode() {
        return this.code;
    }
}

