/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.service.sms;

import com.vaadin.annotations.JavaScript;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.Page;
import com.vaadin.ui.JavaScriptFunction;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.mobile.service.MobileServiceError;
import com.xdev.mobile.service.annotations.MobileService;
import com.xdev.mobile.service.annotations.Plugin;
import com.xdev.mobile.service.sms.SmsOptions;
import com.xdev.mobile.service.sms.SmsServiceAccess;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@MobileService(plugins={@Plugin(name="cordova-sms-plugin", spec="0.1.11")})
@JavaScript(value={"sms.js"})
public class SmsService
extends AbstractMobileService
implements SmsServiceAccess {
    private final Map<String, AbstractMobileService.ServiceCall<Object, MobileServiceError>> sendCalls = new HashMap<String, AbstractMobileService.ServiceCall<Object, MobileServiceError>>();

    public static SmsServiceAccess getInstance() {
        return SmsService.getMobileService(SmsService.class);
    }

    public SmsService(AbstractClientConnector connector, MobileServiceConfiguration configuration) {
        super(connector, configuration);
        this.addFunction("sms_send_success", (JavaScriptFunction & Serializable)jsonArray -> this.sms_send_success(jsonArray));
        this.addFunction("sms_send_error", (JavaScriptFunction & Serializable)jsonArray -> this.sms_send_error(jsonArray));
    }

    @Override
    public void send(String number, String message, SmsOptions options, Runnable successCallback, Consumer<MobileServiceError> errorCallback) {
        Consumer<Object> consumerWrapper = successCallback != null ? object -> successCallback.run() : null;
        String id = this.generateCallerID();
        AbstractMobileService.ServiceCall<Object, MobileServiceError> call = AbstractMobileService.ServiceCall.New(consumerWrapper, errorCallback);
        this.sendCalls.put(id, call);
        StringBuilder js = new StringBuilder();
        js.append("sms_send(").append(this.toLiteral(id)).append(",").append(this.toLiteral(number)).append(",").append(this.toLiteral(message)).append(",").append(this.toJson(options)).append(");");
        Page.getCurrent().getJavaScript().execute(js.toString());
    }

    private String toJson(SmsOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("{replaceLineBreaks:").append(options.isReplaceLineBreaks()).append(",android:{").append("intent:").append(options.isAndroidNativeApp() ? "'INTENT'" : "''").append("}}");
        return sb.toString();
    }

    private void sms_send_success(JsonArray arguments) {
        String id = arguments.getString(0);
        AbstractMobileService.ServiceCall<Object, MobileServiceError> call = this.sendCalls.remove(id);
        if (call != null) {
            call.success(null);
        }
    }

    private void sms_send_error(JsonArray arguments) {
        this.callError(arguments, this.sendCalls, true);
    }
}

