/*
 * Decompiled with CFR 0.152.
 */
package com.xdev.mobile.ui;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.VaadinSession;
import com.xdev.mobile.config.MobileConfiguration;
import com.xdev.mobile.config.MobileServiceConfiguration;
import com.xdev.mobile.service.AbstractMobileService;
import com.xdev.ui.XdevUI;
import com.xdev.ui.XdevUIExtension;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MobileUIExtension
implements XdevUIExtension {
    private static Logger LOG = Logger.getLogger(MobileUIExtension.class.getName());

    public void uiInitialized(XdevUI ui) {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return;
        }
        MobileConfiguration mobileConfiguration = (MobileConfiguration)session.getAttribute(MobileConfiguration.class);
        if (mobileConfiguration == null) {
            return;
        }
        for (MobileServiceConfiguration configuration : mobileConfiguration.getMobileServices()) {
            try {
                Class<? extends AbstractMobileService> clazz = configuration.getServiceClass();
                Constructor<? extends AbstractMobileService> constructor = clazz.getConstructor(AbstractClientConnector.class, MobileServiceConfiguration.class);
                constructor.newInstance(ui, configuration);
                LOG.log(Level.INFO, "Mobile service registered: " + clazz.getName());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

