/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.utils.buffer;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleBuffer<T> {
    private final List<T> buffer;
    private final int mMaxSize;
    private final int printInterval;
    private int count = 0;

    public SimpleBuffer(int size, int printInterval) {
        this.buffer = new ArrayList<T>(size);
        this.mMaxSize = size;
        this.printInterval = printInterval;
    }

    public synchronized void add(T t) {
        int c;
        if ((c = ++this.count) % this.printInterval == 0) {
            this.onInterval(c);
        }
        this.buffer.add(t);
        if (this.buffer.size() >= this.mMaxSize) {
            this.flush();
        }
    }

    public synchronized void flush() {
        try {
            this.doFlush(this.buffer);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            this.buffer.clear();
        }
    }

    protected void onInterval(int count) {
    }

    protected abstract void doFlush(List<T> var1) throws Exception;
}

