/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.utils.buffer;

import com.xzchaoo.utils.buffer.BatchBuffer;
import com.xzchaoo.utils.buffer.BufferFlusher;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncBuffer<T>
implements BatchBuffer<T> {
    private List<T> buffer;
    private int flushSize;
    private BufferFlusher<T> flusher;

    public SyncBuffer(int flushSize) {
        this(flushSize, null);
    }

    public SyncBuffer(int flushSize, BufferFlusher<T> flusher) {
        this.flushSize = flushSize;
        this.buffer = new ArrayList<T>(flushSize);
        this.flusher = flusher;
    }

    @Override
    public synchronized void add(T t) {
        this.buffer.add(t);
        if (this.buffer.size() == this.flushSize) {
            this.flush(true);
        }
    }

    protected void doFlush(List<T> buffer) {
        if (this.flusher != null) {
            this.flusher.flush(buffer);
        }
    }

    @Override
    public synchronized void flush(boolean forceClear) {
        try {
            this.doFlush(this.buffer);
            this.buffer.clear();
        }
        catch (RuntimeException e) {
            if (forceClear) {
                this.buffer.clear();
            }
            throw e;
        }
    }

    @Override
    public synchronized List<T> clear() {
        ArrayList<T> copy = new ArrayList<T>(this.buffer);
        this.buffer.clear();
        return copy;
    }

    @Override
    public synchronized void addAll(List<T> coll) {
        if (this.buffer.size() + coll.size() >= this.flushSize) {
            this.doFlush(this.buffer);
            this.doFlush(coll);
        } else {
            this.buffer.addAll(coll);
        }
    }
}

