/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.provider;

import yandex.cloud.sdk.auth.provider.AuthUpdater;
import yandex.cloud.sdk.auth.provider.CachingCredentialProvider;
import yandex.cloud.sdk.auth.provider.CredentialProvider;

public abstract class AbstractCredentialProviderBuilder<BUILDER extends AbstractCredentialProviderBuilder<BUILDER>>
implements CredentialProvider.Builder {
    private AuthUpdater updater = null;
    private boolean cached = true;

    public BUILDER withDefaultBackgroundUpdater() {
        this.updater = AuthUpdater.builder().stopOnRuntimeShutdown().build();
        return (BUILDER)this;
    }

    public BUILDER withBackgroundUpdater(AuthUpdater updater) {
        this.updater = updater;
        return (BUILDER)this;
    }

    public BUILDER withBackgroundUpdater(AuthUpdater.Builder updater) {
        this.updater = updater.build();
        return (BUILDER)this;
    }

    public BUILDER enableCache() {
        this.cached = true;
        return (BUILDER)this;
    }

    public BUILDER disableCache() {
        this.cached = false;
        return (BUILDER)this;
    }

    @Override
    public CredentialProvider build() {
        CredentialProvider provider = this.providerBuild();
        if (this.updater != null) {
            provider = this.updater.wrapProvider(provider);
        }
        if (this.cached) {
            provider = new CachingCredentialProvider(provider);
        }
        return provider;
    }

    protected abstract CredentialProvider providerBuild();
}

