/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.provider;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import yandex.cloud.api.iam.v1.IamTokenServiceGrpc;
import yandex.cloud.api.iam.v1.IamTokenServiceOuterClass;
import yandex.cloud.sdk.auth.IamToken;
import yandex.cloud.sdk.auth.apikey.ApiKey;
import yandex.cloud.sdk.auth.apikey.InvalidServiceAccountKeyException;
import yandex.cloud.sdk.auth.jwt.JwtCreator;
import yandex.cloud.sdk.auth.jwt.ServiceAccountKey;
import yandex.cloud.sdk.auth.provider.AbstractCredentialProviderBuilder;
import yandex.cloud.sdk.auth.provider.CredentialProvider;

public class ApiKeyCredentialProvider
implements CredentialProvider {
    private final ApiKey key;
    private final IamTokenServiceGrpc.IamTokenServiceBlockingStub iamTokenService;

    private ApiKeyCredentialProvider(ApiKey key, IamTokenServiceGrpc.IamTokenServiceBlockingStub iamTokenService) {
        this.key = key;
        this.iamTokenService = iamTokenService;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public IamToken get() {
        String jwt = this.key.getJwt().getToken();
        IamTokenServiceOuterClass.CreateIamTokenRequest request = IamTokenServiceOuterClass.CreateIamTokenRequest.newBuilder().setJwt(jwt).build();
        IamTokenServiceOuterClass.CreateIamTokenResponse response = this.iamTokenService.create(request);
        return new IamToken(response.getIamToken(), Instant.ofEpochSecond(response.getExpiresAt().getSeconds()));
    }

    public static class Builder
    extends AbstractCredentialProviderBuilder<Builder> {
        private ServiceAccountKey serviceAccountKey;
        private JwtCreator jwtCreator;
        private String endpoint = "iam.api.cloud.yandex.net:443";

        private Builder() {
        }

        public Builder serviceAccountKey(ServiceAccountKey serviceAccountKey) {
            this.serviceAccountKey = serviceAccountKey;
            return this;
        }

        public Builder jwtCreator(JwtCreator jwtCreator) {
            this.jwtCreator = jwtCreator;
            return this;
        }

        public Builder cloudIAMEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder fromJson(String json) {
            this.serviceAccountKey = Builder.readKeyFromJson(json);
            return this;
        }

        public Builder fromEnv(String env) {
            String json = System.getenv(env);
            if (Objects.isNull(json)) {
                throw new IllegalArgumentException(String.format("Environment variable %s is not set", env));
            }
            this.serviceAccountKey = Builder.readKeyFromJson(json);
            return this;
        }

        public Builder fromFile(Path path) {
            this.serviceAccountKey = Builder.readKeyFromJsonFile(path);
            return this;
        }

        @Override
        protected CredentialProvider providerBuild() {
            if (this.serviceAccountKey == null) {
                throw new IllegalStateException("build api key credential provider without service account key");
            }
            ApiKey apiKey = new ApiKey(this.serviceAccountKey);
            if (this.jwtCreator != null) {
                apiKey = apiKey.withJwtCreator(this.jwtCreator);
            }
            ManagedChannel managedChannel = NettyChannelBuilder.forTarget((String)this.endpoint).build();
            IamTokenServiceGrpc.IamTokenServiceBlockingStub stub = IamTokenServiceGrpc.newBlockingStub((Channel)managedChannel);
            return new ApiKeyCredentialProvider(apiKey, stub);
        }

        private static ServiceAccountKey readKeyFromJsonFile(Path path) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (ServiceAccountKey)objectMapper.readValue(path.toFile(), ServiceAccountKey.class);
            }
            catch (JsonParseException | JsonMappingException e) {
                throw new InvalidServiceAccountKeyException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read file from path %s", path), e);
            }
        }

        private static ServiceAccountKey readKeyFromJson(String value) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (ServiceAccountKey)objectMapper.readValue(value, ServiceAccountKey.class);
            }
            catch (JsonParseException | JsonMappingException e) {
                throw new InvalidServiceAccountKeyException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not convert json value to object", e);
            }
        }
    }
}

