/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.grpc;

import java.lang.reflect.InvocationTargetException;
import yandex.cloud.sdk.auth.grpc.ManagedChannelFactory;
import yandex.cloud.sdk.auth.grpc.NettyChannelFactory;
import yandex.cloud.sdk.auth.grpc.ShadedNettyChannelFactory;

class ChannelFactoryLoader {
    private ChannelFactoryLoader() {
    }

    public static ManagedChannelFactory getInstance() {
        return FactoryLoader.factory;
    }

    private static class FactoryLoader {
        private static final String SHADED_DEPS = "io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder";
        private static final String NETTY_DEPS = "io.grpc.netty.NettyChannelBuilder";
        private static ManagedChannelFactory factory;

        private FactoryLoader() {
        }

        private static boolean tryLoad(String name, Class<? extends ManagedChannelFactory> clazz) {
            try {
                Class.forName(name);
                factory = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return true;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                return false;
            }
        }

        static {
            boolean ok;
            boolean bl = ok = FactoryLoader.tryLoad(SHADED_DEPS, ShadedNettyChannelFactory.class) || FactoryLoader.tryLoad(NETTY_DEPS, NettyChannelFactory.class);
            if (!ok) {
                throw new IllegalStateException("Cannot load any ManagedChannelFactory!! Classpath must contain grpc-netty or grpc-netty-shaded");
            }
        }
    }
}

