/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.jwt;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SignatureAlgorithm;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import yandex.cloud.sdk.auth.jwt.Jwt;
import yandex.cloud.sdk.auth.jwt.JwtConfig;
import yandex.cloud.sdk.auth.jwt.ServiceAccountKey;

public class JwtCreator {
    private static final String DEFAULT_ENDPOINT = "https://iam.api.cloud.yandex.net/iam/v1/tokens";
    private static final Duration DEFAULT_TTL = Duration.ofHours(1L);
    private final String endpoint;
    private final Duration ttl;

    public JwtCreator() {
        this.endpoint = DEFAULT_ENDPOINT;
        this.ttl = DEFAULT_TTL;
    }

    public JwtCreator(JwtConfig config) {
        this.endpoint = config.getEndpoint() != null ? config.getEndpoint() : DEFAULT_ENDPOINT;
        this.ttl = config.getTtl() != null ? config.getTtl() : DEFAULT_TTL;
    }

    public Jwt generateJwt(ServiceAccountKey serviceAccountKey) {
        return this.generateJwt(serviceAccountKey, this.ttl);
    }

    public Jwt generateJwt(ServiceAccountKey serviceAccountKey, Duration ttl) {
        SignatureAlgorithm signatureAlgorithm = Jwts.SIG.PS256;
        Instant curInstant = Instant.now();
        Instant exp = curInstant.plus(ttl);
        JwtBuilder builder = ((JwtBuilder)((NestedCollection)Jwts.builder().issuer(serviceAccountKey.getServiceAccountId()).issuedAt(Date.from(curInstant)).expiration(Date.from(exp)).audience().add((Object)this.endpoint)).and()).signWith((Key)serviceAccountKey.getPrivateKey(), (SecureDigestAlgorithm)signatureAlgorithm);
        builder = (JwtBuilder)((JwtBuilder.BuilderHeader)builder.header().add((Object)"kid", (Object)serviceAccountKey.getKeyId())).and();
        return new Jwt(builder.compact(), exp);
    }
}

