/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.provider;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import yandex.cloud.sdk.auth.IamToken;
import yandex.cloud.sdk.auth.metadata.HttpConnectionConfig;
import yandex.cloud.sdk.auth.metadata.InstanceMetadataService;
import yandex.cloud.sdk.auth.provider.AbstractCredentialProviderBuilder;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.auth.provider.UnavailableIamTokenException;

public class ComputeEngineCredentialProvider
implements CredentialProvider {
    private final InstanceMetadataService metadataService;

    private ComputeEngineCredentialProvider(InstanceMetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public IamToken get() {
        try {
            return this.extractToken(this.metadataService.getValue("instance/service-accounts/default/token"));
        }
        catch (IOException e) {
            throw new UnavailableIamTokenException(e);
        }
    }

    private IamToken extractToken(String content) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        TokenResponse response = (TokenResponse)objectMapper.readValue(content, TokenResponse.class);
        return new IamToken(response.accessToken, Instant.now().plusSeconds(response.expiresIn));
    }

    public static class Builder
    extends AbstractCredentialProviderBuilder<Builder> {
        private InstanceMetadataService metadataService = new InstanceMetadataService();

        private Builder() {
        }

        public Builder metadataServerUrl(String metadataServerUrl) {
            this.metadataService = new InstanceMetadataService(HttpConnectionConfig.DEFAULT, metadataServerUrl);
            return this;
        }

        public Builder metadataService(InstanceMetadataService metadataService) {
            this.metadataService = metadataService;
            return this;
        }

        @Override
        protected CredentialProvider providerBuild() {
            return new ComputeEngineCredentialProvider(this.metadataService);
        }
    }

    private static class TokenResponse {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="expires_in")
        private Long expiresIn;
        @JsonProperty(value="token_type")
        private String tokenType;

        private TokenResponse() {
        }
    }
}

