/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.provider;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import yandex.cloud.api.iam.v1.IamTokenServiceGrpc;
import yandex.cloud.api.iam.v1.IamTokenServiceOuterClass;
import yandex.cloud.sdk.auth.IamToken;
import yandex.cloud.sdk.auth.provider.AbstractCredentialProviderBuilder;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.auth.useragent.UserAgent;

public class OauthCredentialProvider
implements CredentialProvider {
    private final String oauth;
    private final IamTokenServiceGrpc.IamTokenServiceBlockingStub iamTokenService;

    private OauthCredentialProvider(String oauth, IamTokenServiceGrpc.IamTokenServiceBlockingStub iamTokenService) {
        this.oauth = oauth;
        this.iamTokenService = iamTokenService;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public IamToken get() {
        IamTokenServiceOuterClass.CreateIamTokenRequest request = IamTokenServiceOuterClass.CreateIamTokenRequest.newBuilder().setYandexPassportOauthToken(this.oauth).build();
        IamTokenServiceOuterClass.CreateIamTokenResponse response = this.iamTokenService.create(request);
        return new IamToken(response.getIamToken(), Instant.ofEpochSecond(response.getExpiresAt().getSeconds()));
    }

    public static class Builder
    extends AbstractCredentialProviderBuilder<Builder> {
        private String oauth;
        private String endpoint = "iam.api.cloud.yandex.net:443";
        private String userAgent = UserAgent.DEFAULT;

        private Builder() {
        }

        public Builder oauth(String oauth) {
            this.oauth = oauth;
            return this;
        }

        public Builder cloudIAMEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder fromFile(Path path) {
            try {
                this.oauth = new String(Files.readAllBytes(path), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read file from path %s", path), e);
            }
            return this;
        }

        public Builder fromEnv(String env) {
            String token = System.getenv(env);
            if (Objects.isNull(token)) {
                throw new IllegalArgumentException(String.format("Environment variable %s is not set", env));
            }
            this.oauth = token;
            return this;
        }

        @Override
        protected CredentialProvider providerBuild() {
            if (this.oauth == null) {
                throw new IllegalStateException("build oauth credential provider without oauth token");
            }
            ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)this.endpoint).userAgent(this.userAgent)).build();
            IamTokenServiceGrpc.IamTokenServiceBlockingStub stub = IamTokenServiceGrpc.newBlockingStub((Channel)channel);
            return new OauthCredentialProvider(this.oauth, stub);
        }
    }
}

