/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class IamToken {
    private final String token;
    private final Instant expiresAt;
    private final Instant updateAt;

    public IamToken(String token, Instant expiresAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        Instant now = Instant.now();
        long expiresIn = expiresAt.getEpochSecond() - now.getEpochSecond();
        Instant updateAt = now.plus((long)((double)expiresIn * 0.1), ChronoUnit.SECONDS);
        if (updateAt.isBefore(now)) {
            updateAt = now;
        }
        this.updateAt = updateAt;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IamToken iamToken = (IamToken)o;
        return Objects.equals(this.token, iamToken.token);
    }

    public int hashCode() {
        return Objects.hash(this.token);
    }

    public String toString() {
        return String.format("IamToken{token='%s'}", this.token != null ? "***" : "null");
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getUpdateAt() {
        return this.updateAt;
    }
}

