/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.vpc;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import yandex.cloud.api.operation.OperationOuterClass;
import yandex.cloud.api.operation.OperationServiceGrpc;
import yandex.cloud.api.vpc.v1.NetworkServiceGrpc;
import yandex.cloud.api.vpc.v1.NetworkServiceOuterClass;
import yandex.cloud.api.vpc.v1.SubnetServiceGrpc;
import yandex.cloud.api.vpc.v1.SubnetServiceOuterClass;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.Zone;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.utils.OperationUtils;

public class VPCExample {
    private static final String MY_YC_FOLDER_ID = "<folder-id>";

    public static void main(String[] args) throws Exception {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(Duration.ofMinutes(1L)).build();
        NetworkServiceGrpc.NetworkServiceBlockingStub networkService = (NetworkServiceGrpc.NetworkServiceBlockingStub)factory.create(NetworkServiceGrpc.NetworkServiceBlockingStub.class, NetworkServiceGrpc::newBlockingStub);
        SubnetServiceGrpc.SubnetServiceBlockingStub subnetService = (SubnetServiceGrpc.SubnetServiceBlockingStub)factory.create(SubnetServiceGrpc.SubnetServiceBlockingStub.class, SubnetServiceGrpc::newBlockingStub);
        OperationServiceGrpc.OperationServiceBlockingStub operationService = (OperationServiceGrpc.OperationServiceBlockingStub)factory.create(OperationServiceGrpc.OperationServiceBlockingStub.class, OperationServiceGrpc::newBlockingStub);
        OperationOuterClass.Operation createOperation = networkService.create(VPCExample.buildCreateNetworkRequest());
        System.out.println("Create network request sent");
        String networkId = ((NetworkServiceOuterClass.CreateNetworkMetadata)createOperation.getMetadata().unpack(NetworkServiceOuterClass.CreateNetworkMetadata.class)).getNetworkId();
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)createOperation, (Duration)Duration.ofMinutes(1L));
        System.out.println(String.format("Created network with id %s", networkId));
        HashMap<Zone, String> zoneToCidr = new HashMap<Zone, String>();
        zoneToCidr.put(Zone.RU_CENTRAL1_A, "192.168.0.0/24");
        zoneToCidr.put(Zone.RU_CENTRAL1_B, "192.168.1.0/24");
        zoneToCidr.put(Zone.RU_CENTRAL1_C, "192.168.2.0/24");
        ArrayList createSubnetOperations = new ArrayList();
        zoneToCidr.forEach((zone, cidr) -> createSubnetOperations.add(subnetService.create(VPCExample.buildCreateSubnetRequest(networkId, zone, cidr))));
        for (OperationOuterClass.Operation operation : createSubnetOperations) {
            String subnetId = ((SubnetServiceOuterClass.CreateSubnetMetadata)operation.getMetadata().unpack(SubnetServiceOuterClass.CreateSubnetMetadata.class)).getSubnetId();
            OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)operation, (Duration)Duration.ofMinutes(1L));
            System.out.println(String.format("Created subnet %s", subnetId));
        }
        NetworkServiceOuterClass.ListNetworkSubnetsResponse subnets = networkService.listSubnets(VPCExample.buildListNetworkSubnetsRequest(networkId));
        ArrayList deleteSubnetOperations = new ArrayList();
        subnets.getSubnetsList().forEach(subnet -> deleteSubnetOperations.add(subnetService.delete(VPCExample.buildDeleteSubnetRequest(subnet.getId()))));
        for (OperationOuterClass.Operation operation : deleteSubnetOperations) {
            String subnetId = ((SubnetServiceOuterClass.DeleteSubnetMetadata)operation.getMetadata().unpack(SubnetServiceOuterClass.DeleteSubnetMetadata.class)).getSubnetId();
            OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)operation, (Duration)Duration.ofMinutes(1L));
            System.out.println(String.format("Deleted subnet %s", subnetId));
        }
        OperationOuterClass.Operation deleteOperation = networkService.delete(VPCExample.buildDeleteNetworkRequest(networkId));
        System.out.println("Delete network request sent");
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)deleteOperation, (Duration)Duration.ofMinutes(1L));
        System.out.println(String.format("Deleted network %s", networkId));
    }

    private static NetworkServiceOuterClass.CreateNetworkRequest buildCreateNetworkRequest() {
        return NetworkServiceOuterClass.CreateNetworkRequest.newBuilder().setName("test-network").setFolderId(MY_YC_FOLDER_ID).build();
    }

    private static SubnetServiceOuterClass.CreateSubnetRequest buildCreateSubnetRequest(String networkId, Zone zone, String v4Cidr) {
        return SubnetServiceOuterClass.CreateSubnetRequest.newBuilder().setFolderId(MY_YC_FOLDER_ID).setName("test-subnet-" + zone.getId()).setNetworkId(networkId).setZoneId(zone.getId()).addV4CidrBlocks(v4Cidr).build();
    }

    private static NetworkServiceOuterClass.ListNetworkSubnetsRequest buildListNetworkSubnetsRequest(String networkId) {
        return NetworkServiceOuterClass.ListNetworkSubnetsRequest.newBuilder().setNetworkId(networkId).build();
    }

    private static SubnetServiceOuterClass.DeleteSubnetRequest buildDeleteSubnetRequest(String subnetId) {
        return SubnetServiceOuterClass.DeleteSubnetRequest.newBuilder().setSubnetId(subnetId).build();
    }

    private static NetworkServiceOuterClass.DeleteNetworkRequest buildDeleteNetworkRequest(String networkId) {
        return NetworkServiceOuterClass.DeleteNetworkRequest.newBuilder().setNetworkId(networkId).build();
    }
}

