/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.kms;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import yandex.cloud.api.kms.v1.SymmetricCryptoServiceGrpc;
import yandex.cloud.api.kms.v1.SymmetricCryptoServiceOuterClass;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;

public class SymmetricCryptoExample {
    private static final String MY_KMS_KEY_ID = "<symmetric-key-id>";

    public static void main(String[] args) {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(Duration.ofMinutes(1L)).build();
        SymmetricCryptoServiceGrpc.SymmetricCryptoServiceBlockingStub symmetricCryptoService = (SymmetricCryptoServiceGrpc.SymmetricCryptoServiceBlockingStub)factory.create(SymmetricCryptoServiceGrpc.SymmetricCryptoServiceBlockingStub.class, SymmetricCryptoServiceGrpc::newBlockingStub);
        String mySecretWord = "my_password";
        SymmetricCryptoServiceOuterClass.SymmetricEncryptResponse encryptResponse = symmetricCryptoService.encrypt(SymmetricCryptoExample.buildEncryptRequest(mySecretWord));
        byte[] ciphertext = encryptResponse.getCiphertext().toByteArray();
        System.out.println(String.format("My secret word \"%s\" encrypted with key %s version %s\nBase64 encoded ciphertext: %s", mySecretWord, encryptResponse.getKeyId(), encryptResponse.getVersionId(), Base64.getEncoder().encodeToString(ciphertext)));
        SymmetricCryptoServiceOuterClass.SymmetricDecryptResponse decryptResponse = symmetricCryptoService.decrypt(SymmetricCryptoExample.buildDecryptRequest(ciphertext));
        byte[] plaintext = decryptResponse.getPlaintext().toByteArray();
        String decryptedSecretWord = new String(plaintext, StandardCharsets.UTF_8);
        System.out.println(String.format("Decrypted secret word \"%s\"", decryptedSecretWord));
    }

    private static SymmetricCryptoServiceOuterClass.SymmetricDecryptRequest buildDecryptRequest(byte[] ciphertext) {
        return SymmetricCryptoServiceOuterClass.SymmetricDecryptRequest.newBuilder().setKeyId(MY_KMS_KEY_ID).setCiphertext(ByteString.copyFrom((byte[])ciphertext)).build();
    }

    private static SymmetricCryptoServiceOuterClass.SymmetricEncryptRequest buildEncryptRequest(String mySecretWord) {
        return SymmetricCryptoServiceOuterClass.SymmetricEncryptRequest.newBuilder().setKeyId(MY_KMS_KEY_ID).setPlaintext(ByteString.copyFrom((String)mySecretWord, (Charset)StandardCharsets.UTF_8)).build();
    }
}

