/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.mdb;

import java.time.Duration;
import yandex.cloud.api.mdb.postgresql.v1.ClusterOuterClass;
import yandex.cloud.api.mdb.postgresql.v1.ClusterServiceGrpc;
import yandex.cloud.api.mdb.postgresql.v1.ClusterServiceOuterClass;
import yandex.cloud.api.mdb.postgresql.v1.DatabaseOuterClass;
import yandex.cloud.api.mdb.postgresql.v1.UserOuterClass;
import yandex.cloud.api.operation.OperationOuterClass;
import yandex.cloud.api.operation.OperationServiceGrpc;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.Zone;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.utils.OperationUtils;

public class PostgreSQLExample {
    private static final String MY_YC_FOLDER_ID = "<folder-id>";
    private static final String MY_YC_NETWORK_ID = "<network-id>";

    public static void main(String[] args) throws Exception {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(Duration.ofMinutes(1L)).build();
        ClusterServiceGrpc.ClusterServiceBlockingStub clusterService = (ClusterServiceGrpc.ClusterServiceBlockingStub)factory.create(ClusterServiceGrpc.ClusterServiceBlockingStub.class, ClusterServiceGrpc::newBlockingStub);
        OperationServiceGrpc.OperationServiceBlockingStub operationService = (OperationServiceGrpc.OperationServiceBlockingStub)factory.create(OperationServiceGrpc.OperationServiceBlockingStub.class, OperationServiceGrpc::newBlockingStub);
        OperationOuterClass.Operation createOperation = clusterService.create(PostgreSQLExample.buildCreateClusterRequest("mypg", "example-db"));
        System.out.println("Create PostgreSQL cluster request sent");
        String clusterId = ((ClusterServiceOuterClass.CreateClusterMetadata)createOperation.getMetadata().unpack(ClusterServiceOuterClass.CreateClusterMetadata.class)).getClusterId();
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)createOperation, (Duration)Duration.ofMinutes(10L));
        System.out.println(String.format("Created with id %s", clusterId));
        OperationOuterClass.Operation deleteOperation = clusterService.delete(PostgreSQLExample.buildDeleteClusterRequest(clusterId));
        System.out.println("Delete PostgreSQL cluster request sent");
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)deleteOperation, (Duration)Duration.ofMinutes(5L));
        System.out.println(String.format("Deleted cluster %s", clusterId));
    }

    private static ClusterServiceOuterClass.CreateClusterRequest buildCreateClusterRequest(String clusterName, String dbName) {
        String user = "user";
        String password = "password";
        return ClusterServiceOuterClass.CreateClusterRequest.newBuilder().setFolderId(MY_YC_FOLDER_ID).setName(clusterName).setEnvironment(ClusterOuterClass.Cluster.Environment.PRODUCTION).setConfigSpec(ClusterServiceOuterClass.ConfigSpec.newBuilder().setVersion("10").setResources(ClusterOuterClass.Resources.newBuilder().setResourcePresetId("s2.micro").setDiskSize(0x280000000L).setDiskTypeId("network-ssd").build()).build()).addDatabaseSpecs(DatabaseOuterClass.DatabaseSpec.newBuilder().setName(dbName).setOwner(user).build()).addUserSpecs(UserOuterClass.UserSpec.newBuilder().setName(user).setPassword(password).addPermissions(UserOuterClass.Permission.newBuilder().setDatabaseName(dbName).build()).build()).addHostSpecs(ClusterServiceOuterClass.HostSpec.newBuilder().setZoneId(Zone.RU_CENTRAL1_B.getId()).setAssignPublicIp(false).build()).setNetworkId(MY_YC_NETWORK_ID).build();
    }

    private static ClusterServiceOuterClass.DeleteClusterRequest buildDeleteClusterRequest(String clusterId) {
        return ClusterServiceOuterClass.DeleteClusterRequest.newBuilder().setClusterId(clusterId).build();
    }
}

