/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.kms;

import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import yandex.cloud.api.kms.v1.SymmetricKeyOuterClass;
import yandex.cloud.api.kms.v1.SymmetricKeyServiceGrpc;
import yandex.cloud.api.kms.v1.SymmetricKeyServiceOuterClass;
import yandex.cloud.api.operation.OperationOuterClass;
import yandex.cloud.api.operation.OperationServiceGrpc;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.utils.OperationUtils;

public class SymmetricKeyExample {
    private static final String MY_YC_FOLDER_ID = "<folder-id>";

    public static void main(String[] args) throws Exception {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(java.time.Duration.ofMinutes(1L)).build();
        SymmetricKeyServiceGrpc.SymmetricKeyServiceBlockingStub symmetricKeyService = (SymmetricKeyServiceGrpc.SymmetricKeyServiceBlockingStub)factory.create(SymmetricKeyServiceGrpc.SymmetricKeyServiceBlockingStub.class, SymmetricKeyServiceGrpc::newBlockingStub);
        OperationServiceGrpc.OperationServiceBlockingStub operationService = (OperationServiceGrpc.OperationServiceBlockingStub)factory.create(OperationServiceGrpc.OperationServiceBlockingStub.class, OperationServiceGrpc::newBlockingStub);
        OperationOuterClass.Operation createOperation = symmetricKeyService.create(SymmetricKeyExample.buildCreateKeyRequest());
        System.out.println("Create symmetric key request sent");
        String keyId = ((SymmetricKeyServiceOuterClass.CreateSymmetricKeyMetadata)createOperation.getMetadata().unpack(SymmetricKeyServiceOuterClass.CreateSymmetricKeyMetadata.class)).getKeyId();
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)createOperation, (java.time.Duration)java.time.Duration.ofSeconds(5L));
        System.out.println(String.format("Created key with id %s", keyId));
        SymmetricKeyOuterClass.SymmetricKey key = symmetricKeyService.get(SymmetricKeyExample.buildGetRequest(keyId));
        System.out.println(String.format("Get symmetric key:\n%s", key.toString()));
        OperationOuterClass.Operation updateOperation = symmetricKeyService.update(SymmetricKeyExample.buildUpdateRequest(keyId));
        updateOperation = OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)updateOperation, (java.time.Duration)java.time.Duration.ofSeconds(5L));
        SymmetricKeyOuterClass.SymmetricKey updatedKey = (SymmetricKeyOuterClass.SymmetricKey)updateOperation.getResponse().unpack(SymmetricKeyOuterClass.SymmetricKey.class);
        System.out.println(String.format("Updated symmetric key:\n%s", updatedKey.toString()));
        String oldPrimaryVersionId = updatedKey.getPrimaryVersion().getId();
        OperationOuterClass.Operation rotateOperation = symmetricKeyService.rotate(SymmetricKeyExample.buildRotateRequest(keyId));
        rotateOperation = OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)rotateOperation, (java.time.Duration)java.time.Duration.ofSeconds(5L));
        String newPrimaryVersionId = ((SymmetricKeyServiceOuterClass.RotateSymmetricKeyMetadata)rotateOperation.getMetadata().unpack(SymmetricKeyServiceOuterClass.RotateSymmetricKeyMetadata.class)).getNewPrimaryVersionId();
        System.out.println(String.format("Symmetric key rotated, new primary version id %s", newPrimaryVersionId));
        OperationOuterClass.Operation scheduleVersionDestructionOperation = symmetricKeyService.scheduleVersionDestruction(SymmetricKeyExample.buildScheduleVersionDestructionRequest(keyId, oldPrimaryVersionId));
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)scheduleVersionDestructionOperation, (java.time.Duration)java.time.Duration.ofSeconds(5L));
        String scheduledVersionId = ((SymmetricKeyServiceOuterClass.ScheduleSymmetricKeyVersionDestructionMetadata)scheduleVersionDestructionOperation.getMetadata().unpack(SymmetricKeyServiceOuterClass.ScheduleSymmetricKeyVersionDestructionMetadata.class)).getVersionId();
        System.out.println(String.format("Version %s scheduled for destruction", scheduledVersionId));
        OperationOuterClass.Operation deleteOperation = symmetricKeyService.delete(SymmetricKeyExample.buildDeleteRequest(keyId));
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)deleteOperation, (java.time.Duration)java.time.Duration.ofSeconds(5L));
        String deletedKeyId = ((SymmetricKeyServiceOuterClass.DeleteSymmetricKeyMetadata)deleteOperation.getMetadata().unpack(SymmetricKeyServiceOuterClass.DeleteSymmetricKeyMetadata.class)).getKeyId();
        System.out.println(String.format("Symmetric key with id %s deleted", deletedKeyId));
    }

    private static SymmetricKeyServiceOuterClass.DeleteSymmetricKeyRequest buildDeleteRequest(String keyId) {
        return SymmetricKeyServiceOuterClass.DeleteSymmetricKeyRequest.newBuilder().setKeyId(keyId).build();
    }

    private static SymmetricKeyServiceOuterClass.ScheduleSymmetricKeyVersionDestructionRequest buildScheduleVersionDestructionRequest(String keyId, String versionId) {
        return SymmetricKeyServiceOuterClass.ScheduleSymmetricKeyVersionDestructionRequest.newBuilder().setKeyId(keyId).setVersionId(versionId).setPendingPeriod(Duration.newBuilder().setSeconds(java.time.Duration.ofHours(1L).getSeconds())).build();
    }

    private static SymmetricKeyServiceOuterClass.RotateSymmetricKeyRequest buildRotateRequest(String keyId) {
        return SymmetricKeyServiceOuterClass.RotateSymmetricKeyRequest.newBuilder().setKeyId(keyId).build();
    }

    private static SymmetricKeyServiceOuterClass.UpdateSymmetricKeyRequest buildUpdateRequest(String keyId) {
        FieldMask updateMask = FieldMask.newBuilder().addPaths("name").addPaths("description").addPaths("default_algorithm").addPaths("rotation_period").addPaths("status").build();
        return SymmetricKeyServiceOuterClass.UpdateSymmetricKeyRequest.newBuilder().setUpdateMask(updateMask).setKeyId(keyId).setName("MY_UPDATED_KEY").setDescription("MY_UPDATED_DESCRIPTION").setDefaultAlgorithm(SymmetricKeyOuterClass.SymmetricAlgorithm.AES_128).setRotationPeriod(Duration.newBuilder().setSeconds(java.time.Duration.ofDays(30L).getSeconds())).setStatus(SymmetricKeyOuterClass.SymmetricKey.Status.INACTIVE).build();
    }

    private static SymmetricKeyServiceOuterClass.GetSymmetricKeyRequest buildGetRequest(String keyId) {
        return SymmetricKeyServiceOuterClass.GetSymmetricKeyRequest.newBuilder().setKeyId(keyId).build();
    }

    private static SymmetricKeyServiceOuterClass.CreateSymmetricKeyRequest buildCreateKeyRequest() {
        return SymmetricKeyServiceOuterClass.CreateSymmetricKeyRequest.newBuilder().setFolderId(MY_YC_FOLDER_ID).setDefaultAlgorithm(SymmetricKeyOuterClass.SymmetricAlgorithm.AES_256).setName("MY_NEW_KEY").setDescription("MY_EXAMPLE_KEY").setRotationPeriod(Duration.newBuilder().setSeconds(java.time.Duration.ofDays(7L).getSeconds())).build();
    }
}

