/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.compute;

import java.time.Duration;
import java.util.List;
import yandex.cloud.api.compute.v1.ImageOuterClass;
import yandex.cloud.api.compute.v1.ImageServiceGrpc;
import yandex.cloud.api.compute.v1.ImageServiceOuterClass;
import yandex.cloud.api.compute.v1.InstanceServiceGrpc;
import yandex.cloud.api.compute.v1.InstanceServiceOuterClass;
import yandex.cloud.api.operation.OperationOuterClass;
import yandex.cloud.api.operation.OperationServiceGrpc;
import yandex.cloud.sdk.Platform;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.Zone;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.utils.OperationUtils;

public class ComputeExample {
    private static final String MY_YC_FOLDER_ID = "<folder-id>";
    private static final String MY_YC_CENTRAL1_B_SUBNET_ID = "<subnet-id>";
    private static final String YC_STANDARD_IMAGES = "standard-images";
    private static final String YC_UBUNTU_IMAGE_FAMILY = "ubuntu-1804";

    public static void main(String[] args) throws Exception {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(Duration.ofMinutes(1L)).build();
        InstanceServiceGrpc.InstanceServiceBlockingStub instanceService = (InstanceServiceGrpc.InstanceServiceBlockingStub)factory.create(InstanceServiceGrpc.InstanceServiceBlockingStub.class, InstanceServiceGrpc::newBlockingStub);
        OperationServiceGrpc.OperationServiceBlockingStub operationService = (OperationServiceGrpc.OperationServiceBlockingStub)factory.create(OperationServiceGrpc.OperationServiceBlockingStub.class, OperationServiceGrpc::newBlockingStub);
        ImageServiceGrpc.ImageServiceBlockingStub imageService = (ImageServiceGrpc.ImageServiceBlockingStub)factory.create(ImageServiceGrpc.ImageServiceBlockingStub.class, ImageServiceGrpc::newBlockingStub);
        ImageOuterClass.Image image = imageService.getLatestByFamily(ComputeExample.buildGetLatestByFamilyRequest());
        OperationOuterClass.Operation createOperation = instanceService.create(ComputeExample.buildCreateInstanceRequest(image.getId()));
        System.out.println("Create instance request sent");
        String instanceId = ((InstanceServiceOuterClass.CreateInstanceMetadata)createOperation.getMetadata().unpack(InstanceServiceOuterClass.CreateInstanceMetadata.class)).getInstanceId();
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)createOperation, (Duration)Duration.ofMinutes(5L));
        System.out.println(String.format("Created with id %s", instanceId));
        List instances = instanceService.list(ComputeExample.buildListInstancesRequest()).getInstancesList();
        instances.forEach(System.out::println);
        System.out.println("Listed instances");
        OperationOuterClass.Operation deleteOperation = instanceService.delete(ComputeExample.buildDeleteInstanceRequest(instanceId));
        System.out.println("Delete instance request sent");
        OperationUtils.wait((OperationServiceGrpc.OperationServiceBlockingStub)operationService, (OperationOuterClass.Operation)deleteOperation, (Duration)Duration.ofMinutes(1L));
        System.out.println(String.format("Deleted instance %s", instanceId));
    }

    private static ImageServiceOuterClass.GetImageLatestByFamilyRequest buildGetLatestByFamilyRequest() {
        return ImageServiceOuterClass.GetImageLatestByFamilyRequest.newBuilder().setFolderId(YC_STANDARD_IMAGES).setFamily(YC_UBUNTU_IMAGE_FAMILY).build();
    }

    private static InstanceServiceOuterClass.CreateInstanceRequest buildCreateInstanceRequest(String imageId) {
        return InstanceServiceOuterClass.CreateInstanceRequest.newBuilder().setFolderId(MY_YC_FOLDER_ID).setName("ubuntu").setZoneId(Zone.RU_CENTRAL1_B.getId()).setPlatformId(Platform.STANDARD_V1.getId()).setResourcesSpec(InstanceServiceOuterClass.ResourcesSpec.newBuilder().setCores(1L).setMemory(0x40000000L)).setBootDiskSpec(InstanceServiceOuterClass.AttachedDiskSpec.newBuilder().setDiskSpec(InstanceServiceOuterClass.AttachedDiskSpec.DiskSpec.newBuilder().setImageId(imageId).setSize(0x280000000L))).addNetworkInterfaceSpecs(InstanceServiceOuterClass.NetworkInterfaceSpec.newBuilder().setSubnetId(MY_YC_CENTRAL1_B_SUBNET_ID).setPrimaryV4AddressSpec(InstanceServiceOuterClass.PrimaryAddressSpec.getDefaultInstance())).build();
    }

    private static InstanceServiceOuterClass.ListInstancesRequest buildListInstancesRequest() {
        return InstanceServiceOuterClass.ListInstancesRequest.newBuilder().setFolderId(MY_YC_FOLDER_ID).build();
    }

    private static InstanceServiceOuterClass.DeleteInstanceRequest buildDeleteInstanceRequest(String instanceId) {
        return InstanceServiceOuterClass.DeleteInstanceRequest.newBuilder().setInstanceId(instanceId).build();
    }
}

