/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.examples.ai;

import java.time.Duration;
import yandex.cloud.api.ai.translate.v2.TranslationServiceGrpc;
import yandex.cloud.api.ai.translate.v2.TranslationServiceOuterClass;
import yandex.cloud.sdk.ServiceFactory;
import yandex.cloud.sdk.auth.Auth;
import yandex.cloud.sdk.auth.provider.CredentialProvider;

public class TranslateExample {
    private static final String MY_YC_FOLDER_ID = "<folder-id>";

    public static void main(String[] args) {
        ServiceFactory factory = ServiceFactory.builder().credentialProvider((CredentialProvider.Builder)Auth.oauthTokenBuilder().fromEnv("YC_OAUTH")).requestTimeout(Duration.ofMinutes(1L)).build();
        TranslationServiceGrpc.TranslationServiceBlockingStub translationService = (TranslationServiceGrpc.TranslationServiceBlockingStub)factory.create(TranslationServiceGrpc.TranslationServiceBlockingStub.class, TranslationServiceGrpc::newBlockingStub);
        String text = "hello world";
        TranslationServiceOuterClass.TranslateResponse response = translationService.translate(TranslateExample.buildTranslateRequest(text));
        String translation = response.getTranslations(0).getText();
        System.out.println(String.format("%s -> %s", text, translation));
    }

    private static TranslationServiceOuterClass.TranslateRequest buildTranslateRequest(String text) {
        return TranslationServiceOuterClass.TranslateRequest.newBuilder().setSourceLanguageCode("en").setTargetLanguageCode("ru").setFormat(TranslationServiceOuterClass.TranslateRequest.Format.PLAIN_TEXT).addTexts(text).setFolderId(MY_YC_FOLDER_ID).build();
    }
}

