/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.functions;

import java.net.http.HttpHeaders;
import yandex.cloud.sdk.functions.Context;
import yandex.cloud.sdk.functions.exception.HeaderNotFoundException;

public class YcFunctionContext
implements Context {
    public static final String HEADER_REQUEST_ID = "Lambda-Runtime-Aws-Request-Id";
    public static final String HEADER_FUNCTION_NAME = "Lambda-Runtime-Function-Name";
    public static final String HEADER_FUNCTION_VERSION_ID = "Lambda-Runtime-Function-Version";
    public static final String HEADER_MEMORY_LIMIT = "Lambda-Runtime-Memory-Limit";
    public static final String HEADER_TOKEN_JSON = "Lambda-Runtime-Token-Json";
    private final String requestId;
    private final String functionId;
    private final String functionVersionId;
    private final int memoryLimit;
    private final String tokenJson;

    public YcFunctionContext(HttpHeaders headers) {
        this.requestId = headers.firstValue(HEADER_REQUEST_ID).orElseThrow(() -> new HeaderNotFoundException(HEADER_REQUEST_ID));
        this.functionId = headers.firstValue(HEADER_FUNCTION_NAME).orElseThrow(() -> new HeaderNotFoundException(HEADER_FUNCTION_NAME));
        this.functionVersionId = headers.firstValue(HEADER_FUNCTION_VERSION_ID).orElseThrow(() -> new HeaderNotFoundException(HEADER_FUNCTION_VERSION_ID));
        this.memoryLimit = Integer.parseInt(headers.firstValue(HEADER_MEMORY_LIMIT).orElseThrow(() -> new HeaderNotFoundException(HEADER_MEMORY_LIMIT)));
        this.tokenJson = headers.firstValue(HEADER_TOKEN_JSON).orElse("");
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    @Override
    public String getFunctionVersionId() {
        return this.functionVersionId;
    }

    @Override
    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getTokenJson() {
        return this.tokenJson;
    }
}

