/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.utils;

import java.time.Duration;
import java.time.Instant;
import yandex.cloud.api.operation.OperationOuterClass;
import yandex.cloud.api.operation.OperationServiceGrpc;
import yandex.cloud.api.operation.OperationServiceOuterClass;
import yandex.cloud.sdk.utils.OperationTimeoutException;

public class OperationUtils {
    public static OperationOuterClass.Operation wait(OperationServiceGrpc.OperationServiceBlockingStub operationService, OperationOuterClass.Operation operation, Duration timeout) throws InterruptedException, OperationTimeoutException {
        return OperationUtils.wait(operationService, operation, timeout, Duration.ofMillis(500L));
    }

    public static OperationOuterClass.Operation wait(OperationServiceGrpc.OperationServiceBlockingStub operationService, OperationOuterClass.Operation operation, Duration timeout, Duration pollInterval) throws InterruptedException, OperationTimeoutException {
        if (operation.getDone()) {
            return operation;
        }
        if ((operation = OperationUtils.get(operationService, operation)).getDone()) {
            return operation;
        }
        Instant deadline = Instant.now().plus(timeout);
        while (!operation.getDone() && Instant.now().isBefore(deadline)) {
            Thread.sleep(pollInterval.toMillis());
            operation = OperationUtils.get(operationService, operation);
        }
        if (operation.getDone()) {
            return operation;
        }
        throw new OperationTimeoutException(operation.getId());
    }

    private static OperationOuterClass.Operation get(OperationServiceGrpc.OperationServiceBlockingStub operationService, OperationOuterClass.Operation operation) {
        return operationService.get(OperationServiceOuterClass.GetOperationRequest.newBuilder().setOperationId(operation.getId()).build());
    }
}

