/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.UUID;

public class RequestIdInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> CLIENT_REQUEST_ID = Metadata.Key.of((String)"x-client-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> CLIENT_TRACE_ID = Metadata.Key.of((String)"x-client-trace-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final String requestId = UUID.randomUUID().toString();
        final String traceId = UUID.randomUUID().toString();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(CLIENT_REQUEST_ID, (Object)requestId);
                headers.put(CLIENT_TRACE_ID, (Object)traceId);
                super.start(responseListener, headers);
            }
        };
    }
}

