/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.AccountStatus;
import com.yandex.money.api.model.AccountType;
import com.yandex.money.api.model.Avatar;
import com.yandex.money.api.model.BalanceDetails;
import com.yandex.money.api.model.Card;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Currency;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class AccountInfo
implements MethodResponse {
    private final String account;
    private final BigDecimal balance;
    private final Currency currency;
    private final AccountStatus accountStatus;
    private final AccountType accountType;
    private final Avatar avatar;
    private final BalanceDetails balanceDetails;
    private final Card[] linkedCards;
    private final String[] additionalServices;

    public AccountInfo(String account, BigDecimal balance, Currency currency, AccountStatus accountStatus, AccountType accountType, Avatar avatar, BalanceDetails balanceDetails, Card[] linkedCards, String[] additionalServices) {
        if (Strings.isNullOrEmpty(account)) {
            throw new IllegalArgumentException("account is null or empty");
        }
        this.account = account;
        if (balance == null) {
            throw new IllegalArgumentException("balance is null");
        }
        this.balance = balance;
        this.currency = currency;
        this.accountStatus = accountStatus;
        this.accountType = accountType;
        this.avatar = avatar;
        this.balanceDetails = balanceDetails;
        this.linkedCards = linkedCards;
        this.additionalServices = additionalServices;
    }

    public String getAccount() {
        return this.account;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public BalanceDetails getBalanceDetails() {
        return this.balanceDetails;
    }

    public Card[] getLinkedCards() {
        return this.linkedCards;
    }

    public String[] getAdditionalServices() {
        return this.additionalServices;
    }

    public boolean isIdentified() {
        return this.accountStatus == AccountStatus.IDENTIFIED;
    }

    public String toString() {
        return "AccountInfo{account='" + this.account + '\'' + ", balance=" + this.balance + ", currency=" + (Object)((Object)this.currency) + ", accountStatus=" + (Object)((Object)this.accountStatus) + ", accountType=" + (Object)((Object)this.accountType) + ", avatar=" + this.avatar + ", balanceDetails=" + this.balanceDetails + ", linkedCards=" + Arrays.toString(this.linkedCards) + ", additionalServices=" + Arrays.toString(this.additionalServices) + '}';
    }

    private static final class Deserializer
    implements JsonDeserializer<AccountInfo> {
        private Deserializer() {
        }

        public AccountInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Currency currency;
            JsonObject object = json.getAsJsonObject();
            try {
                int parsed = Integer.parseInt(JsonUtils.getString(object, "currency"));
                currency = Currency.parseNumericCode(parsed);
            }
            catch (NumberFormatException e) {
                currency = Currency.RUB;
            }
            String memberAvatar = "avatar";
            Avatar avatar = null;
            if (object.has("avatar")) {
                avatar = Avatar.createFromJson(object.get("avatar"));
            }
            String memberBalanceDetails = "balance_details";
            BalanceDetails balanceDetails = null;
            if (object.has("balance_details")) {
                balanceDetails = BalanceDetails.createFromJson(object.get("balance_details"));
            }
            String memberLinkedCards = "cards_linked";
            Card[] linkedCards = null;
            if (object.has("cards_linked")) {
                JsonArray array = object.getAsJsonArray("cards_linked");
                int size = array.size();
                linkedCards = new Card[size];
                for (int i = 0; i < size; ++i) {
                    linkedCards[i] = Card.createFromJson(array.get(i));
                }
            }
            String memberAdditionalServices = "services_additional";
            String[] additionalServices = null;
            if (object.has("services_additional")) {
                JsonArray array = object.getAsJsonArray("services_additional");
                int size = array.size();
                additionalServices = new String[size];
                for (int i = 0; i < size; ++i) {
                    additionalServices[i] = array.get(i).getAsString();
                }
            }
            return new AccountInfo(JsonUtils.getMandatoryString(object, "account"), JsonUtils.getMandatoryBigDecimal(object, "balance"), currency, AccountStatus.parse(JsonUtils.getString(object, "account_status")), AccountType.parse(JsonUtils.getString(object, "account_type")), avatar, balanceDetails, linkedCards, additionalServices);
        }
    }

    public static final class Request
    implements MethodRequest<AccountInfo> {
        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/account-info");
        }

        @Override
        public AccountInfo parseResponse(InputStream inputStream) {
            return (AccountInfo)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), AccountInfo.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return null;
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(AccountInfo.class, (Object)new Deserializer()).create();
        }
    }
}

