/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.model.Scope;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class AuxToken
implements MethodResponse {
    private final String auxToken;
    private final Error error;

    public AuxToken(String auxToken, Error error) {
        this.auxToken = auxToken;
        this.error = error;
    }

    public String toString() {
        return "AuxToken{auxToken='" + this.auxToken + '\'' + ", error=" + (Object)((Object)this.error) + '}';
    }

    public String getAuxToken() {
        return this.auxToken;
    }

    public Error getError() {
        return this.error;
    }

    private static final class Deserializer
    implements JsonDeserializer<AuxToken> {
        private Deserializer() {
        }

        public AuxToken deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new AuxToken(JsonUtils.getString(object, "aux_token"), Error.parse(JsonUtils.getString(object, "error")));
        }
    }

    public static final class Request
    implements MethodRequest<AuxToken> {
        private final Set<Scope> scopes;

        public Request(Set<Scope> scopes) {
            if (scopes == null || scopes.isEmpty()) {
                throw new IllegalArgumentException("scopes is null or empty");
            }
            this.scopes = scopes;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/token-aux");
        }

        @Override
        public AuxToken parseResponse(InputStream inputStream) {
            return (AuxToken)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), AuxToken.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("scope", Scope.createScopeParameter(this.scopes.iterator()));
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(AuxToken.class, (Object)new Deserializer()).create();
        }
    }
}

