/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.MethodResponse;
import java.util.Map;

public abstract class BaseProcessPayment
implements MethodResponse {
    protected static final String MEMBER_STATUS = "status";
    protected static final String MEMBER_ERROR = "error";
    protected static final String MEMBER_ACS_URI = "acs_uri";
    protected static final String MEMBER_ACS_PARAMS = "acs_params";
    protected static final String MEMBER_NEXT_RETRY = "next_retry";
    private final Status status;
    private final Error error;
    private final String acsUri;
    private final Map<String, String> acsParams;
    private final Long nextRetry;

    public BaseProcessPayment(Status status, Error error, String acsUri, Map<String, String> acsParams, Long nextRetry) {
        if (status == Status.EXT_AUTH_REQUIRED && acsUri == null) {
            throw new NullPointerException("acsUri is null when status is ext_auth_required");
        }
        this.status = status;
        this.error = error;
        this.acsUri = acsUri;
        this.acsParams = acsParams;
        this.nextRetry = nextRetry;
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public String getAcsUri() {
        return this.acsUri;
    }

    public Map<String, String> getAcsParams() {
        return this.acsParams;
    }

    public Long getNextRetry() {
        return this.nextRetry;
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        IN_PROGRESS("in_progress"),
        EXT_AUTH_REQUIRED("ext_auth_required"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

