/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.MethodResponse;
import java.math.BigDecimal;

public abstract class BaseRequestPayment
implements MethodResponse {
    protected static final String MEMBER_STATUS = "status";
    protected static final String MEMBER_ERROR = "error";
    protected static final String MEMBER_REQUEST_ID = "request_id";
    protected static final String MEMBER_CONTRACT_AMOUNT = "contract_amount";
    private final Status status;
    private final Error error;
    private final String requestId;
    private final BigDecimal contractAmount;

    protected BaseRequestPayment(Status status, Error error, String requestId, BigDecimal contractAmount) {
        if (status == Status.SUCCESS && requestId == null) {
            throw new IllegalArgumentException("requestId is null when status is success");
        }
        this.status = status;
        this.error = error;
        this.requestId = requestId;
        this.contractAmount = contractAmount;
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BigDecimal getContractAmount() {
        return this.contractAmount;
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        HOLD_FOR_PICKUP("hold_for_pickup"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

