/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class IncomingTransferAccept
implements MethodResponse {
    private final Status status;
    private final Error error;
    private final Integer protectionCodeAttemptsAvailable;
    private final String extActionUri;

    public IncomingTransferAccept(Status status, Error error, Integer protectionCodeAttemptsAvailable, String extActionUri) {
        this.status = status;
        this.error = error;
        this.protectionCodeAttemptsAvailable = protectionCodeAttemptsAvailable;
        this.extActionUri = extActionUri;
    }

    public String toString() {
        return "IncomingTransferAccept{status=" + (Object)((Object)this.status) + ", error=" + (Object)((Object)this.error) + ", protectionCodeAttemptsAvailable=" + this.protectionCodeAttemptsAvailable + ", extActionUri='" + this.extActionUri + '\'' + '}';
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public Integer getProtectionCodeAttemptsAvailable() {
        return this.protectionCodeAttemptsAvailable;
    }

    public String getExtActionUri() {
        return this.extActionUri;
    }

    private static final class Deserializer
    implements JsonDeserializer<IncomingTransferAccept> {
        private Deserializer() {
        }

        public IncomingTransferAccept deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new IncomingTransferAccept(Status.parse(JsonUtils.getMandatoryString(object, "status")), Error.parse(JsonUtils.getString(object, "error")), JsonUtils.getInt(object, "protection_code_attempts_available"), JsonUtils.getString(object, "ext_action_uri"));
        }
    }

    public static final class Request
    implements MethodRequest<IncomingTransferAccept> {
        private final String operationId;
        private final String protectionCode;

        public Request(String operationId, String protectionCode) {
            if (operationId == null || operationId.isEmpty()) {
                throw new IllegalArgumentException("operationId is null or empty");
            }
            this.operationId = operationId;
            this.protectionCode = protectionCode;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/incoming-transfer-accept");
        }

        @Override
        public IncomingTransferAccept parseResponse(InputStream inputStream) {
            return (IncomingTransferAccept)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), IncomingTransferAccept.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("operation_id", this.operationId).addParamIfNotNull("protection_code", this.protectionCode);
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(IncomingTransferAccept.class, (Object)new Deserializer()).create();
        }
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

