/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class IncomingTransferReject
implements MethodResponse {
    private final Status status;
    private final Error error;

    public IncomingTransferReject(Status status, Error error) {
        this.status = status;
        this.error = error;
    }

    public String toString() {
        return "IncomingTransferReject{status=" + (Object)((Object)this.status) + ", error=" + (Object)((Object)this.error) + '}';
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    private static final class Deserializer
    implements JsonDeserializer<IncomingTransferReject> {
        private Deserializer() {
        }

        public IncomingTransferReject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new IncomingTransferReject(Status.parse(JsonUtils.getMandatoryString(object, "status")), Error.parse(JsonUtils.getString(object, "error")));
        }
    }

    public static final class Request
    implements MethodRequest<IncomingTransferReject> {
        private String operationId;

        public Request(String operationId) {
            if (operationId == null || operationId.isEmpty()) {
                throw new IllegalArgumentException("operationId is null or empty");
            }
            this.operationId = operationId;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/incoming-transfer-reject");
        }

        @Override
        public IncomingTransferReject parseResponse(InputStream inputStream) {
            return (IncomingTransferReject)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), IncomingTransferReject.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("operation_id", this.operationId);
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(Request.class, (Object)new Deserializer()).create();
        }
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

