/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class InstanceId
implements MethodResponse {
    private Status status;
    private Error error;
    private String instanceId;

    public InstanceId(Status status, Error error, String instanceId) {
        this.status = status;
        this.error = error;
        this.instanceId = instanceId;
    }

    public String toString() {
        return "InstanceId{status=" + (Object)((Object)this.status) + ", error=" + (Object)((Object)this.error) + ", instanceId='" + this.instanceId + '\'' + '}';
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public static class Request
    implements MethodRequest<InstanceId> {
        private String clientId;

        public Request(String clientId) {
            if (Strings.isNullOrEmpty(clientId)) {
                throw new IllegalArgumentException("clientId is null or empty");
            }
            this.clientId = clientId;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/instance-id");
        }

        @Override
        public InstanceId parseResponse(InputStream inputStream) {
            return (InstanceId)new GsonBuilder().registerTypeAdapter(InstanceId.class, (Object)new JsonDeserializer<InstanceId>(){

                public InstanceId deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject o = json.getAsJsonObject();
                    return new InstanceId(Status.parse(JsonUtils.getString(o, "status")), Error.parse(JsonUtils.getString(o, "error")), JsonUtils.getString(o, "instance_id"));
                }
            }).create().fromJson((Reader)new InputStreamReader(inputStream), InstanceId.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("client_id", this.clientId);
        }
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

